@extends('layouts.dashboard.app')

@section('style')
<style>
/* Modern Car Damage Selector Styles */
.car-damage-card {
    background: #fff;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    border: 1px solid #e2e8f0;
    margin: 20px auto;
    max-width: 800px;
}

.car-damage-header {
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    color: #fff;
    padding: 16px 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.car-damage-header h5 {
    margin: 0;
    font-size: 15px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 10px;
}

.car-damage-header .icon {
    width: 28px;
    height: 28px;
    background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.selected-count-badge {
    background: #fbbf24;
    color: #1a1a2e;
    padding: 4px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.selected-count-badge.has-selection {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #fff;
}

.car-damage-body {
    padding: 20px;
    background: linear-gradient(180deg, #f8fafc 0%, #fff 100%);
    display: flex;
    flex-direction: column;
    align-items: center;
}

.car-svg-container {
    max-width: 400px;
    margin: 0 auto;
    position: relative;
}

.car-svg-container svg {
    width: 100%;
    height: auto;
    display: block;
}

/* Car Zone Styles */
.car-zone {
    cursor: pointer;
    transition: all 0.2s ease;
}

.car-zone:hover {
    filter: brightness(1.1);
    stroke: #10b981 !important;
    stroke-width: 2px !important;
}

.car-zone.selected {
    fill: url(#selectedGradient) !important;
    filter: drop-shadow(0 0 8px rgba(249, 115, 22, 0.6));
    animation: zonePulse 2s ease-in-out infinite;
}

.car-zone.selected:hover {
    filter: drop-shadow(0 0 12px rgba(249, 115, 22, 0.8)) brightness(1.05);
}

@keyframes zonePulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.85; }
}

/* Selected Zones Display */
.selected-zones-container {
    background: #f8fafc;
    border-radius: 10px;
    padding: 14px;
    border: 1px solid #e2e8f0;
    margin-top: 16px;
    width: 100%;
    max-width: 600px;
}

.selected-zones-label {
    font-size: 12px;
    color: #64748b;
    margin-bottom: 8px;
    font-weight: 500;
}

.zones-tags {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    min-height: 32px;
    align-items: center;
}

.zones-tags .empty-message {
    color: #94a3b8;
    font-size: 13px;
    font-style: italic;
}

.zone-tag {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #fff;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
    animation: tagFadeIn 0.3s ease;
    box-shadow: 0 2px 8px rgba(16, 185, 129, 0.3);
}

@keyframes tagFadeIn {
    from { opacity: 0; transform: scale(0.9); }
    to { opacity: 1; transform: scale(1); }
}

.zone-tag .remove-zone {
    cursor: pointer;
    opacity: 0.8;
    transition: opacity 0.2s;
    font-size: 14px;
    line-height: 1;
}

.zone-tag .remove-zone:hover {
    opacity: 1;
}

/* Legend */
.damage-legend {
    display: flex;
    justify-content: center;
    gap: 25px;
    margin-top: 16px;
    padding-top: 16px;
    border-top: 1px solid #e2e8f0;
    width: 100%;
}

.legend-item {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 12px;
    color: #64748b;
}

.legend-color {
    width: 24px;
    height: 14px;
    border-radius: 4px;
    border: 1px solid rgba(0,0,0,0.1);
}

.legend-color.selected {
    background: linear-gradient(135deg, #f97316, #ea580c);
}

.legend-color.normal {
    background: linear-gradient(135deg, #e2e8f0, #f1f5f9);
}

/* Tooltip */
.zone-tooltip {
    position: fixed;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    color: #fff;
    padding: 8px 14px;
    border-radius: 8px;
    font-size: 12px;
    font-weight: 500;
    pointer-events: none;
    opacity: 0;
    transition: opacity 0.15s ease;
    z-index: 10000;
    box-shadow: 0 4px 15px rgba(0,0,0,0.3);
    white-space: nowrap;
}

.zone-tooltip.visible {
    opacity: 1;
}

/* Save Button */
.save-points-btn {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #fff;
    border: none;
    border-radius: 8px;
    padding: 8px 24px;
    font-size: 14px;
    font-weight: 600;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    box-shadow: 0 2px 10px rgba(16, 185, 129, 0.3);
    transition: all 0.2s ease;
    min-width: 120px;
}

.save-points-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
    color: #fff;
}

.save-points-btn:disabled {
    opacity: 0.7;
    cursor: not-allowed;
    transform: none;
}

.skip-btn {
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    color: #64748b;
    border-radius: 8px;
    padding: 8px 20px;
    font-size: 14px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.2s ease;
}

.skip-btn:hover {
    background: #f1f5f9;
    color: #475569;
}
</style>
@endsection

@section('content')
<div class="row d-flex justify-content-center">
    <div class="col-12 text-center mt-3">
        <h2>Sélection des Points de Choc</h2>
        <p class="text-muted">Cliquez sur les zones du véhicule pour les sélectionner</p>
    </div>

    <div class="car-damage-card">
        <div class="car-damage-header">
            <h5>
                <span class="icon">
                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"/>
                        <path d="M12 8v8M8 12h8"/>
                    </svg>
                </span>
                Points de Choc
                <span id="selectedCountBadge" class="selected-count-badge">0 sélectionné(s)</span>
            </h5>
            <div class="d-flex gap-2">
                <a href="{{ route('Dossier.show', $dossier->id) }}" class="skip-btn">Passer</a>
                <button type="button" id="savePointsBtn" class="save-points-btn">
                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="20 6 9 17 4 12"/>
                    </svg>
                    <span class="btn-text">Valider</span>
                    <span class="btn-loading d-none">
                        <span class="spinner-border spinner-border-sm"></span>
                    </span>
                </button>
            </div>
        </div>
        
        <div class="car-damage-body">
            <form id="shockPointsForm" action="{{ route('ShockPoint.store') }}" method="POST">
                @csrf
                <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                <input type="hidden" name="points" id="pointsInput" value="">
                <input type="hidden" name="img" id="svgImageData" value="">
                
                <div class="car-svg-container">
                    <svg id="voitureSvg" viewBox="0 0 400 700" xmlns="http://www.w3.org/2000/svg">
                        <defs>
                            <linearGradient id="bodyGradient" x1="0%" y1="0%" x2="100%" y2="0%">
                                <stop offset="0%" stop-color="#e2e8f0"/>
                                <stop offset="50%" stop-color="#f1f5f9"/>
                                <stop offset="100%" stop-color="#e2e8f0"/>
                            </linearGradient>
                            <linearGradient id="glassGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                                <stop offset="0%" stop-color="#93c5fd"/>
                                <stop offset="100%" stop-color="#3b82f6"/>
                            </linearGradient>
                            <linearGradient id="wheelGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#374151"/>
                                <stop offset="100%" stop-color="#1f2937"/>
                            </linearGradient>
                            <linearGradient id="selectedGradient" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#f97316"/>
                                <stop offset="100%" stop-color="#ea580c"/>
                            </linearGradient>
                            
                            <!-- Filters for realistic effects -->
                            <filter id="shadowFilter" x="-20%" y="-20%" width="140%" height="140%">
                                <feDropShadow dx="0" dy="4" stdDeviation="8" flood-color="#000" flood-opacity="0.15"/>
                            </filter>
                        </defs>

                        <!-- Car Shadow -->
                        <ellipse cx="200" cy="660" rx="120" ry="20" fill="#000" opacity="0.1"/>

                        <!-- Main Car Body -->
                        <g filter="url(#shadowFilter)">
                            <path d="M100,120 Q100,80 140,60 L260,60 Q300,80 300,120 L300,580 Q300,620 260,640 L140,640 Q100,620 100,580 Z" 
                                  fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="2"/>
                        </g>

                        <!-- FRONT SECTION -->
                        <path id="zone-1" data-zone="1" data-name="Pare-chocs Avant" class="car-zone"
                              d="M120,60 Q120,40 160,30 L240,30 Q280,40 280,60 L260,60 Q260,50 240,45 L160,45 Q140,50 140,60 Z"
                              fill="#cbd5e1" stroke="#94a3b8" stroke-width="1"/>
                        
                        <path id="zone-2" data-zone="2" data-name="Calandre" class="car-zone"
                              d="M150,60 L250,60 L245,75 L155,75 Z"
                              fill="#64748b" stroke="#475569" stroke-width="1"/>

                        <path id="zone-3" data-zone="3" data-name="Capot" class="car-zone"
                              d="M140,75 L260,75 L270,180 Q200,190 130,180 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>
                        <line x1="200" y1="85" x2="200" y2="170" stroke="#cbd5e1" stroke-width="1" pointer-events="none"/>

                        <ellipse id="zone-26" data-zone="26" data-name="Phare Avant Gauche" class="car-zone"
                                 cx="135" cy="70" rx="15" ry="10" fill="#fef3c7" stroke="#fbbf24" stroke-width="1"/>
                        
                        <ellipse id="zone-27" data-zone="27" data-name="Phare Avant Droit" class="car-zone"
                                 cx="265" cy="70" rx="15" ry="10" fill="#fef3c7" stroke="#fbbf24" stroke-width="1"/>

                        <!-- LEFT SIDE -->
                        <path id="zone-17" data-zone="17" data-name="Aile Avant Gauche" class="car-zone"
                              d="M100,80 L130,75 L130,180 L100,175 Q95,130 100,80 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>

                        <g id="zone-18" data-zone="18" data-name="Roue Avant Gauche" class="car-zone">
                            <rect x="85" y="120" width="25" height="50" rx="5" fill="url(#wheelGradient)" stroke="#1f2937" stroke-width="1"/>
                            <ellipse cx="97" cy="145" rx="8" ry="8" fill="#4b5563" pointer-events="none"/>
                            <circle cx="97" cy="145" r="3" fill="#9ca3af" pointer-events="none"/>
                        </g>

                        <ellipse id="zone-34" data-zone="34" data-name="Rétroviseur Gauche" class="car-zone"
                                 cx="95" cy="210" rx="12" ry="8" fill="#64748b" stroke="#475569" stroke-width="1"/>

                        <path id="zone-19" data-zone="19" data-name="Porte Avant Gauche" class="car-zone"
                              d="M100,200 L130,200 L130,340 L100,340 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>
                        <rect x="105" y="260" width="15" height="6" rx="2" fill="#94a3b8" pointer-events="none"/>

                        <path id="zone-20" data-zone="20" data-name="Porte Arrière Gauche" class="car-zone"
                              d="M100,345 L130,345 L130,480 L100,480 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>
                        <rect x="105" y="400" width="15" height="6" rx="2" fill="#94a3b8" pointer-events="none"/>

                        <path id="zone-21" data-zone="21" data-name="Aile Arrière Gauche" class="car-zone"
                              d="M100,485 L130,485 L130,580 L100,575 Q95,530 100,485 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>

                        <g id="zone-22" data-zone="22" data-name="Roue Arrière Gauche" class="car-zone">
                            <rect x="85" y="505" width="25" height="50" rx="5" fill="url(#wheelGradient)" stroke="#1f2937" stroke-width="1"/>
                            <ellipse cx="97" cy="530" rx="8" ry="8" fill="#4b5563" pointer-events="none"/>
                            <circle cx="97" cy="530" r="3" fill="#9ca3af" pointer-events="none"/>
                        </g>

                        <!-- RIGHT SIDE -->
                        <path id="zone-8" data-zone="8" data-name="Aile Avant Droite" class="car-zone"
                              d="M270,75 L300,80 Q305,130 300,175 L270,180 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>

                        <g id="zone-9" data-zone="9" data-name="Roue Avant Droite" class="car-zone">
                            <rect x="290" y="120" width="25" height="50" rx="5" fill="url(#wheelGradient)" stroke="#1f2937" stroke-width="1"/>
                            <ellipse cx="302" cy="145" rx="8" ry="8" fill="#4b5563" pointer-events="none"/>
                            <circle cx="302" cy="145" r="3" fill="#9ca3af" pointer-events="none"/>
                        </g>

                        <ellipse id="zone-30" data-zone="30" data-name="Rétroviseur Droit" class="car-zone"
                                 cx="305" cy="210" rx="12" ry="8" fill="#64748b" stroke="#475569" stroke-width="1"/>

                        <path id="zone-10" data-zone="10" data-name="Porte Avant Droite" class="car-zone"
                              d="M270,200 L300,200 L300,340 L270,340 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>
                        <rect x="280" y="260" width="15" height="6" rx="2" fill="#94a3b8" pointer-events="none"/>

                        <path id="zone-11" data-zone="11" data-name="Porte Arrière Droite" class="car-zone"
                              d="M270,345 L300,345 L300,480 L270,480 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>
                        <rect x="280" y="400" width="15" height="6" rx="2" fill="#94a3b8" pointer-events="none"/>

                        <path id="zone-12" data-zone="12" data-name="Aile Arrière Droite" class="car-zone"
                              d="M270,485 L300,485 Q305,530 300,575 L270,580 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>

                        <g id="zone-13" data-zone="13" data-name="Roue Arrière Droite" class="car-zone">
                            <rect x="290" y="505" width="25" height="50" rx="5" fill="url(#wheelGradient)" stroke="#1f2937" stroke-width="1"/>
                            <ellipse cx="302" cy="530" rx="8" ry="8" fill="#4b5563" pointer-events="none"/>
                            <circle cx="302" cy="530" r="3" fill="#9ca3af" pointer-events="none"/>
                        </g>

                        <!-- CENTER / GLASS -->
                        <path id="zone-28" data-zone="28" data-name="Pare-brise" class="car-zone"
                              d="M130,185 Q200,195 270,185 L260,240 Q200,250 140,240 Z"
                              fill="url(#glassGradient)" stroke="#2563eb" stroke-width="1" opacity="0.8"/>
                        <path d="M130,185 L140,240" stroke="#94a3b8" stroke-width="4" stroke-linecap="round" pointer-events="none"/>
                        <path d="M270,185 L260,240" stroke="#94a3b8" stroke-width="4" stroke-linecap="round" pointer-events="none"/>

                        <path id="zone-4" data-zone="4" data-name="Toit" class="car-zone"
                              d="M140,245 Q200,255 260,245 L265,450 Q200,460 135,450 Z"
                              fill="#f8fafc" stroke="#e2e8f0" stroke-width="1"/>
                        <rect x="160" y="300" width="80" height="100" rx="8" fill="#cbd5e1" stroke="#94a3b8" stroke-width="1" pointer-events="none" opacity="0.5"/>
                        <rect x="130" y="335" width="8" height="20" fill="#94a3b8" pointer-events="none"/>
                        <rect x="262" y="335" width="8" height="20" fill="#94a3b8" pointer-events="none"/>

                        <path id="zone-29" data-zone="29" data-name="Lunette Arrière" class="car-zone"
                              d="M140,455 Q200,465 260,455 L270,510 Q200,520 130,510 Z"
                              fill="url(#glassGradient)" stroke="#2563eb" stroke-width="1" opacity="0.8"/>
                        <path d="M140,455 L130,510" stroke="#94a3b8" stroke-width="4" stroke-linecap="round" pointer-events="none"/>
                        <path d="M260,455 L270,510" stroke="#94a3b8" stroke-width="4" stroke-linecap="round" pointer-events="none"/>

                        <!-- REAR SECTION -->
                        <path id="zone-6" data-zone="6" data-name="Coffre" class="car-zone"
                              d="M130,515 Q200,525 270,515 L265,580 Q200,590 135,580 Z"
                              fill="url(#bodyGradient)" stroke="#cbd5e1" stroke-width="1"/>
                        <line x1="200" y1="525" x2="200" y2="575" stroke="#cbd5e1" stroke-width="1" pointer-events="none"/>

                        <path id="zone-23" data-zone="23" data-name="Feu Arrière Gauche" class="car-zone"
                              d="M130,575 L145,575 L145,600 L130,595 Z"
                              fill="#fca5a5" stroke="#ef4444" stroke-width="1"/>
                        
                        <path id="zone-14" data-zone="14" data-name="Feu Arrière Droit" class="car-zone"
                              d="M255,575 L270,575 L270,595 L255,600 Z"
                              fill="#fca5a5" stroke="#ef4444" stroke-width="1"/>

                        <path id="zone-7" data-zone="7" data-name="Pare-chocs Arrière" class="car-zone"
                              d="M130,585 L145,600 L255,600 L270,585 L280,600 Q280,630 240,640 L160,640 Q120,630 120,600 Z"
                              fill="#cbd5e1" stroke="#94a3b8" stroke-width="1"/>

                        <rect x="165" y="610" width="70" height="20" rx="3" fill="#fff" stroke="#94a3b8" stroke-width="1" pointer-events="none"/>
                        <text x="200" y="623" text-anchor="middle" font-size="8" fill="#64748b" pointer-events="none">●●●●●●</text>
                    </svg>
                </div>

                <div class="selected-zones-container">
                    <div class="selected-zones-label">Zones sélectionnées:</div>
                    <div class="zones-tags" id="zonesTags">
                        <span class="empty-message">Cliquez sur les zones du véhicule pour les sélectionner</span>
                    </div>
                </div>

                <div class="damage-legend">
                    <div class="legend-item">
                        <span class="legend-color selected"></span>
                        <span>Zone impactée</span>
                    </div>
                    <div class="legend-item">
                        <span class="legend-color normal"></span>
                        <span>Zone intacte</span>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Tooltip element -->
<div id="zoneTooltip" class="zone-tooltip"></div>
@endsection

@section('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // ========================================
    // STATE MANAGEMENT
    // ========================================
    
    var selectedZones = new Set();
    var carZones = document.querySelectorAll('#voitureSvg .car-zone');
    var pointsInput = document.getElementById('pointsInput');
    var countBadge = document.getElementById('selectedCountBadge');
    var zonesTags = document.getElementById('zonesTags');
    var tooltip = document.getElementById('zoneTooltip');
    var saveBtn = document.getElementById('savePointsBtn');
    var form = document.getElementById('shockPointsForm');
    
    // Zone names mapping (French)
    var zoneNames = {
        '1': 'Pare-chocs Avant',
        '2': 'Calandre',
        '3': 'Capot',
        '4': 'Toit',
        '6': 'Coffre',
        '7': 'Pare-chocs Arrière',
        '8': 'Aile Avant Droite',
        '9': 'Roue Avant Droite',
        '10': 'Porte Avant Droite',
        '11': 'Porte Arrière Droite',
        '12': 'Aile Arrière Droite',
        '13': 'Roue Arrière Droite',
        '14': 'Feu Arrière Droit',
        '17': 'Aile Avant Gauche',
        '18': 'Roue Avant Gauche',
        '19': 'Porte Avant Gauche',
        '20': 'Porte Arrière Gauche',
        '21': 'Aile Arrière Gauche',
        '22': 'Roue Arrière Gauche',
        '23': 'Feu Arrière Gauche',
        '26': 'Phare Avant Gauche',
        '27': 'Phare Avant Droit',
        '28': 'Pare-brise',
        '29': 'Lunette Arrière',
        '30': 'Rétroviseur Droit',
        '34': 'Rétroviseur Gauche'
    };
    
    // ========================================
    // INITIALIZE FROM DATABASE
    // ========================================
    
    @if(isset($dossier) && $dossier->shockpoint && $dossier->shockpoint->count() > 0)
        var existingZones = [@foreach($dossier->shockpoint as $sp){{ $sp->id }},@endforeach];
        existingZones.forEach(function(zoneId) {
            var zoneStr = String(zoneId);
            selectedZones.add(zoneStr);
            var el = document.querySelector('[data-zone="' + zoneStr + '"]');
            if (el) {
                el.classList.add('selected');
            }
        });
        updateUI();
    @endif
    
    // ========================================
    // UI UPDATE FUNCTIONS
    // ========================================
    
    function updateUI() {
        updateHiddenInput();
        updateCountBadge();
        updateZonesTags();
    }
    
    function updateHiddenInput() {
        if (pointsInput) {
            pointsInput.value = Array.from(selectedZones).join(',');
        }
    }
    
    function updateCountBadge() {
        var count = selectedZones.size;
        countBadge.textContent = count + ' sélectionné' + (count !== 1 ? 's' : '');
        
        if (count > 0) {
            countBadge.classList.add('has-selection');
        } else {
            countBadge.classList.remove('has-selection');
        }
    }
    
    function updateZonesTags() {
        if (selectedZones.size === 0) {
            zonesTags.innerHTML = '<span class="empty-message">Cliquez sur les zones du véhicule pour les sélectionner</span>';
            return;
        }
        
        var html = '';
        selectedZones.forEach(function(zoneId) {
            var name = zoneNames[zoneId] || ('Zone ' + zoneId);
            html += '<span class="zone-tag" data-zone="' + zoneId + '">' +
                    name + 
                    '<span class="remove-zone" onclick="window.removeZone(\'' + zoneId + '\')">✕</span>' +
                    '</span>';
        });
        zonesTags.innerHTML = html;
    }
    
    // ========================================
    // ZONE INTERACTION
    // ========================================
    
    window.removeZone = function(zoneId) {
        selectedZones.delete(zoneId);
        var el = document.querySelector('[data-zone="' + zoneId + '"]');
        if (el) {
            el.classList.remove('selected');
        }
        updateUI();
    };
    
    carZones.forEach(function(zone) {
        zone.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            var zoneId = this.dataset.zone;
            
            if (selectedZones.has(zoneId)) {
                selectedZones.delete(zoneId);
                this.classList.remove('selected');
            } else {
                selectedZones.add(zoneId);
                this.classList.add('selected');
            }
            
            updateUI();
        });
        
        zone.addEventListener('mouseenter', function() {
            var name = this.dataset.name || zoneNames[this.dataset.zone] || ('Zone ' + this.dataset.zone);
            tooltip.textContent = name;
            tooltip.classList.add('visible');
        });
        
        zone.addEventListener('mousemove', function(e) {
            tooltip.style.left = (e.clientX + 15) + 'px';
            tooltip.style.top = (e.clientY + 10) + 'px';
        });
        
        zone.addEventListener('mouseleave', function() {
            tooltip.classList.remove('visible');
        });
    });
    
    // ========================================
    // FORM SUBMISSION
    // ========================================
    
    if (saveBtn) {
        saveBtn.addEventListener('click', function(e) {
            e.preventDefault();
            
            updateHiddenInput();
            
            saveBtn.disabled = true;
            saveBtn.querySelector('.btn-text').classList.add('d-none');
            saveBtn.querySelector('.btn-loading').classList.remove('d-none');
            
            generateSvgImage(function(imageData) {
                document.getElementById('svgImageData').value = imageData;
                form.submit();
            });
        });
    }
    
    function generateSvgImage(callback) {
        try {
            var svg = document.getElementById('voitureSvg');
            var svgData = new XMLSerializer().serializeToString(svg);
            var canvas = document.createElement('canvas');
            var ctx = canvas.getContext('2d');
            var img = new Image();
            
            canvas.width = 400;
            canvas.height = 700;
            
            img.onload = function() {
                ctx.fillStyle = '#fff';
                ctx.fillRect(0, 0, canvas.width, canvas.height);
                ctx.drawImage(img, 0, 0);
                var dataUrl = canvas.toDataURL('image/png');
                callback(dataUrl);
            };
            
            img.onerror = function() {
                console.error('Error loading SVG');
                callback('');
            };
            
            img.src = 'data:image/svg+xml;base64,' + btoa(unescape(encodeURIComponent(svgData)));
        } catch (err) {
            console.error('Error generating image:', err);
            callback('');
        }
    }
});
</script>
@endsection
