@extends('layouts.dashboard.app')

@section('style')
{{-- Select2 CSS --}}
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
    /* ========================================
       SELECT2 MODERN THEME
       ======================================== */
    .select2-container--default .select2-selection--single {
        border: 1px solid #e2e8f0 !important;
        border-radius: 8px !important;
        height: 44px !important;
        padding: 6px 8px !important;
        background: #f8fafc !important;
        transition: all 0.2s ease;
    }
    
    .select2-container--default.select2-container--focus .select2-selection--single,
    .select2-container--default.select2-container--open .select2-selection--single {
        border-color: #10b981 !important;
        box-shadow: 0 0 0 3px rgba(16,185,129,0.1) !important;
        background: #fff !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 28px !important;
        padding-left: 4px !important;
        color: #334155 !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 42px !important;
    }
    
    .select2-dropdown {
        border: 1px solid #e2e8f0 !important;
        border-radius: 8px !important;
        box-shadow: 0 10px 40px rgba(0,0,0,0.1) !important;
        margin-top: 4px !important;
    }
    
    .select2-container--default .select2-results__option--highlighted[aria-selected] {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%) !important;
    }
    
    .select2-container--default .select2-search--dropdown .select2-search__field {
        border: 1px solid #e2e8f0 !important;
        border-radius: 6px !important;
        padding: 8px 12px !important;
        transition: border-color 0.2s ease;
    }
    
    .select2-container--default .select2-search--dropdown .select2-search__field:focus {
        border-color: #10b981 !important;
        outline: none !important;
    }
    
    .select2-container--default .select2-results__option[aria-selected=true] {
        background-color: rgba(16,185,129,0.1) !important;
        color: #059669 !important;
    }
    
    .select2-container {
        width: 100% !important;
    }

    /* ========================================
       WIZARD NAVIGATION STYLING
       ======================================== */
    .form-wizard-header .nav-link {
        border: 1px solid #e2e8f0;
        background: #f8fafc;
        color: #64748b;
        transition: all 0.3s ease;
    }
    
    .form-wizard-header .nav-link.active {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        border-color: #059669;
        color: white;
        box-shadow: 0 4px 12px rgba(16,185,129,0.3);
    }
    
    .form-wizard-header .nav-link:hover:not(.active) {
        background: #f1f5f9;
        border-color: #cbd5e1;
    }

    /* ========================================
       CARD & FORM ENHANCEMENTS
       ======================================== */
    .card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    .form-label {
        font-weight: 500;
        color: #374151;
        margin-bottom: 0.5rem;
    }
    
    .form-control:focus,
    .form-select:focus {
        border-color: #10b981;
        box-shadow: 0 0 0 3px rgba(16,185,129,0.1);
    }

    /* ========================================
       BUTTON STYLING
       ======================================== */
    .btn-primary {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        border: none;
        padding: 10px 24px;
        font-weight: 500;
        border-radius: 8px;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        background: linear-gradient(135deg, #059669 0%, #047857 100%);
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(16,185,129,0.3);
    }
    
    .btn-success {
        background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
        border: none;
        padding: 10px 24px;
        font-weight: 500;
        border-radius: 8px;
    }
    
    .btn-secondary {
        background: #f1f5f9;
        border: 1px solid #e2e8f0;
        color: #475569;
        padding: 10px 24px;
        font-weight: 500;
        border-radius: 8px;
    }
    
    .btn-secondary:hover {
        background: #e2e8f0;
        color: #334155;
    }

    /* ========================================
       LOADING STATE
       ======================================== */
    .livewire-loading {
        position: relative;
    }
    
    .livewire-loading::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(255,255,255,0.7);
        display: flex;
        align-items: center;
        justify-content: center;
    }

    /* ========================================
       RESPONSIVE ADJUSTMENTS
       ======================================== */
    @media (max-width: 768px) {
        .form-wizard-header .nav-link span {
            display: none;
        }
        
        .form-wizard-header .nav-link i {
            margin-right: 0 !important;
        }
    }

    /* ========================================
       TOAST NOTIFICATIONS
       ======================================== */
    .toast-container {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
    }
    
    .toast-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
        padding: 12px 20px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(16,185,129,0.3);
        animation: slideIn 0.3s ease;
    }
    
    @keyframes slideIn {
        from {
            transform: translateX(100%);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }
</style>
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        {{-- Page Header --}}
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h4 class="mb-1">
                    <i class="mdi mdi-folder-plus me-2 text-primary"></i>
                    Nouveau Dossier
                </h4>
                <p class="text-muted mb-0">Créer un nouveau dossier de sinistre</p>
            </div>
            <a href="{{ route('Dossier.index') }}" class="btn btn-outline-secondary">
                <i class="mdi mdi-arrow-left me-1"></i> Retour
            </a>
        </div>
        
        {{-- Wizard Component --}}
        <livewire:dossier-wizard />
    </div>
</div>

{{-- Toast Container --}}
<div class="toast-container" id="toastContainer"></div>
@endsection

@section('script')
{{-- Select2 JS --}}
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
(function() {
    'use strict';
    
    // ========================================
    // TOAST NOTIFICATIONS
    // ========================================
    window.showToast = function(message, type = 'success') {
        const container = document.getElementById('toastContainer');
        const toast = document.createElement('div');
        toast.className = 'toast-' + type;
        toast.innerHTML = '<i class="mdi mdi-check-circle me-2"></i>' + message;
        container.appendChild(toast);
        
        setTimeout(() => {
            toast.style.animation = 'slideIn 0.3s ease reverse';
            setTimeout(() => toast.remove(), 300);
        }, 3000);
    };
    
    // ========================================
    // SELECT2 INITIALIZATION
    // ========================================
    function initSelect2() {
        if (typeof jQuery === 'undefined' || typeof jQuery.fn.select2 === 'undefined') {
            console.log('Select2 not loaded yet, retrying...');
            setTimeout(initSelect2, 100);
            return;
        }
        
        // Initialize Select2 on searchable fields
        jQuery('.select2-searchable').each(function() {
            const $field = jQuery(this);
            
            if ($field.hasClass('select2-hidden-accessible')) {
                return; // Already initialized
            }
            
            const placeholder = $field.data('placeholder') || 'Rechercher...';
            const livewireField = $field.data('field');
            
            $field.select2({
                placeholder: placeholder,
                allowClear: true,
                width: '100%',
                language: {
                    noResults: function() { return 'Aucun résultat trouvé'; },
                    searching: function() { return 'Recherche en cours...'; }
                }
            });
            
            // Sync with Livewire
            $field.on('change', function(e) {
                const component = getLivewireComponent();
                if (component && livewireField) {
                    component.set(livewireField, e.target.value, true);
                }
            });
        });
    }
    
    // ========================================
    // LIVEWIRE HELPERS
    // ========================================
    function getLivewireComponent() {
        const el = document.querySelector('[wire\\:id]');
        if (el && window.Livewire) {
            return window.Livewire.find(el.getAttribute('wire:id'));
        }
        return null;
    }
    
    // ========================================
    // KEYBOARD SHORTCUTS
    // ========================================
    document.addEventListener('keydown', function(e) {
        // Ctrl/Cmd + Enter to submit
        if ((e.ctrlKey || e.metaKey) && e.key === 'Enter') {
            const submitBtn = document.querySelector('button[type="submit"]');
            if (submitBtn) {
                submitBtn.click();
            }
        }
        
        // Escape to close dropdowns
        if (e.key === 'Escape') {
            document.querySelectorAll('.search-results-dropdown').forEach(dropdown => {
                dropdown.style.display = 'none';
            });
        }
    });
    
    // ========================================
    // INITIALIZATION
    // ========================================
    function initAll() {
        console.log('Initializing dossier wizard...');
        initSelect2();
    }
    
    // Run on DOM ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initAll);
    } else {
        initAll();
    }
    
    // Run on Livewire load
    document.addEventListener('livewire:load', function() {
        console.log('Livewire loaded');
        initAll();
        
        // Re-initialize after Livewire updates
        Livewire.hook('message.processed', function(message, component) {
            setTimeout(initSelect2, 150);
        });
        
        // Listen for custom events
        Livewire.on('dossierCreated', function(data) {
            showToast('Dossier créé avec succès!');
        });
        
        Livewire.on('dossierImported', function() {
            showToast('Données importées du dossier existant');
            
            // Refresh bootstrap-select pickers
            if (jQuery.fn.selectpicker) {
                jQuery('.selectpicker').selectpicker('refresh');
            }
        });
    });
    
    // Safety fallback
    setTimeout(initAll, 500);
})();
</script>
@endsection