@extends('layouts.config_dashboard.app')

@section('content')

    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="myTable">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Nom</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Restore</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($users as $user)
                                    <tr>
                                        <td>{{ $user->id }}</td>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>{{ $user->role->role }}</td>
                                        <td>
                                            <form action="{{ route('user.restore', [$user->id]) }}" method="post">
                                                @csrf
                                                <button class="btn btn-sm btn-warning" type="submit">Restaurer</button>
                                            </form>
                                        </td>
                                    </tr>
                                    @empty
                                    <h3>Tableau Vide</h3>
                                @endforelse
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
