@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des Modeles</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <a style="float: left" href="{{ route('Modele.create') }}"
                                        class="btn btn-success rounded-pill"> Créer</a>
                                </div>
                                <div class="col-md-6">
                                    <a style="float: right" href="{{ route('Modele.deleted') }}"
                                        class="btn btn-warning rounded-pill"> Restaurer</a>
                                </div>

                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Marque</th>
                                        <th>Modele</th>
                                        <th>Code</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @forelse ($models as $model)
                                        <tr>
                                            <td>{{ $model->id }}</td>
                                            <td>{{ $model->brand->brand}}</td>
                                            <td>{{ $model->name }}</td>
                                            <td>{{ $model->code }}</td>
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Modele.edit', [$model->id]) }}"><i
                                                        class="uil uil-pen fs-5"></i></a></td>
                                            <td>
                                                <form action="{{ route('Modele.destroy', [$model->id]) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit"><i
                                                            class="uil uil-trash fs-5"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
