@extends('layouts.test')

@section('style')
<style>
/* ============================================
   FRONT DASHBOARD - MODERN REDESIGN
   ============================================ */

/* Loader Overlay - Modern Style */
#loaderOverlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(26, 26, 46, 0.97) 0%, rgba(22, 33, 62, 0.97) 100%);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    backdrop-filter: blur(10px);
}

#loaderOverlay.hidden {
    display: none !important;
}

.loader-spinner {
    width: 60px;
    height: 60px;
    border: 4px solid rgba(255, 255, 255, 0.1);
    border-top-color: #10b981;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

.loader-title {
    margin-top: 25px;
    font-size: 18px;
    font-weight: 600;
    color: #fff;
}

.loader-subtitle {
    margin-top: 8px;
    font-size: 14px;
    color: rgba(255, 255, 255, 0.6);
}

.loader-progress-container {
    margin-top: 20px;
    width: 250px;
    height: 6px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 10px;
    overflow: hidden;
}

.loader-progress-bar {
    height: 100%;
    background: linear-gradient(90deg, #10b981, #059669);
    width: 0%;
    transition: width 0.3s ease;
    border-radius: 10px;
}

/* Header Card */
.header-card {
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    border-radius: 16px;
    padding: 25px 30px;
    margin-bottom: 20px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
}

.header-card .page-title {
    font-size: 28px;
    font-weight: 700;
    color: #fff;
    margin: 0 0 15px 0;
}

.header-stats {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}

.stat-item {
    display: flex;
    align-items: center;
    gap: 8px;
}

.stat-item .stat-label {
    font-size: 13px;
    color: rgba(255, 255, 255, 0.6);
}

.stat-item .stat-value {
    font-size: 15px;
    font-weight: 700;
    color: #fff;
    background: rgba(255, 255, 255, 0.1);
    padding: 4px 12px;
    border-radius: 20px;
}

.stat-item .stat-value.pending {
    background: rgba(245, 158, 11, 0.2);
    color: #fbbf24;
}

.stat-item .stat-value.success {
    background: rgba(16, 185, 129, 0.2);
    color: #10b981;
}

/* Action Bar */
.action-bar {
    display: flex;
    align-items: center;
    justify-content: space-between;
    flex-wrap: wrap;
    gap: 15px;
    margin-bottom: 20px;
}

.export-btn {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 12px 24px;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #fff;
    border: none;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
}

.export-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
}

.export-btn i {
    font-size: 18px;
}

.load-progress {
    display: none;
    align-items: center;
    gap: 10px;
    padding: 10px 20px;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.load-progress .progress-icon {
    width: 20px;
    height: 20px;
    border: 2px solid #e2e8f0;
    border-top-color: #10b981;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}
.load-progress .progress-status {
    position: relative;
    width: 20px;
    height: 20px;
}

.load-progress .progress-spinner {
    width: 20px;
    height: 20px;
    border: 2px solid #e2e8f0;
    border-top-color: #10b981;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}

.load-progress .progress-check {
    position: absolute;
    top: 0;
    left: 0;
    width: 20px;
    height: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.load-progress .progress-check.hidden {
    display: none;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

.load-progress .progress-text {
    font-size: 13px;
    color: #64748b;
    font-weight: 500;
}

/* Table Card */
.table-card {
    background: #fff;
    border-radius: 16px;
    box-shadow: 0 2px 20px rgba(0, 0, 0, 0.06);
    overflow: hidden;
}

.table-card .card-body {
    padding: 0;
}

/* Table Styles */
.table-responsive {
    overflow-x: auto;
}

#myTable {
    width: 100%;
    border-collapse: collapse;
}

#myTable thead th {
    background: #f8fafc;
    border-bottom: 2px solid #e2e8f0;
    color: #475569;
    font-weight: 600;
    font-size: 11px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    padding: 16px 12px;
    white-space: nowrap;
    position: sticky;
    top: 0;
    z-index: 10;
}

#myTable tbody td {
    padding: 14px 12px;
    vertical-align: middle;
    border-bottom: 1px solid #f1f5f9;
    color: #334155;
    font-size: 13px;
}

#myTable tbody tr {
    transition: all 0.2s ease;
}

#myTable tbody tr:hover {
    background: #f8fafc;
}

#myTable tbody tr.table-success {
    background: rgba(16, 185, 129, 0.08) !important;
}

#myTable tbody tr.table-success:hover {
    background: rgba(16, 185, 129, 0.12) !important;
}

/* Reference column */
.ref-cell {
    font-weight: 700;
    color: #1a1a2e;
}

/* Badge styles */
.badge {
    padding: 5px 10px;
    font-weight: 500;
    font-size: 11px;
    border-radius: 6px;
    letter-spacing: 0.3px;
}

.badge-type {
    background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
    color: #059669;
}

.badge-mode {
    background: linear-gradient(135deg, #e0f2fe 0%, #bae6fd 100%);
    color: #0284c7;
}

.badge-amount {
    background: #f1f5f9;
    color: #475569;
    font-family: 'Monaco', 'Consolas', monospace;
}

.badge-step {
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    color: #fff;
}

.badge-time {
    padding: 5px 10px;
    font-weight: 600;
    font-size: 11px;
    border-radius: 6px;
}

.badge-time.positive {
    background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    color: #b45309;
}

.badge-time.negative {
    background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
    color: #dc2626;
}

/* Action Links */
.action-links {
    display: flex;
    align-items: center;
    gap: 8px;
}

.doc-link {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 6px 12px;
    background: #f1f5f9;
    color: #475569;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.2s ease;
    white-space: nowrap;
}

.doc-link:hover {
    background: #e2e8f0;
    color: #1a1a2e;
    text-decoration: none;
}

.doc-link.devis:hover {
    background: #dbeafe;
    color: #2563eb;
}

.doc-link.rapport:hover {
    background: #fef3c7;
    color: #b45309;
}

.doc-link.facture:hover {
    background: #d1fae5;
    color: #059669;
}

/* View Button */
.view-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
    background: linear-gradient(135deg, #e0f2fe 0%, #bae6fd 100%);
    color: #0284c7;
    border-radius: 10px;
    text-decoration: none;
    transition: all 0.2s ease;
}

.view-btn:hover {
    background: linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%);
    color: #fff;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(14, 165, 233, 0.4);
    text-decoration: none;
}

.view-btn i {
    font-size: 18px;
}

/* DataTables Overrides */
.dataTables_wrapper {
    padding: 20px;
}

.dataTables_wrapper .dataTables_length {
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length select {
    border: 2px solid #e2e8f0;
    border-radius: 8px;
    padding: 8px 35px 8px 12px;
    font-size: 14px;
    color: #334155;
    cursor: pointer;
    transition: all 0.2s ease;
}

.dataTables_wrapper .dataTables_length select:focus {
    border-color: #10b981;
    outline: none;
    box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
}

.dataTables_wrapper .dataTables_filter {
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_filter input {
    border: 2px solid #e2e8f0;
    border-radius: 10px;
    padding: 10px 15px;
    font-size: 14px;
    min-width: 250px;
    transition: all 0.2s ease;
}

.dataTables_wrapper .dataTables_filter input:focus {
    border-color: #10b981;
    outline: none;
    box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
}

.dataTables_wrapper .dataTables_info {
    color: #64748b;
    font-size: 13px;
    padding: 15px 0;
}

.dataTables_wrapper .dataTables_paginate {
    padding: 15px 0;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    border: none !important;
    border-radius: 8px !important;
    padding: 8px 14px !important;
    margin: 0 3px !important;
    font-size: 13px;
    font-weight: 500;
    transition: all 0.2s ease;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%) !important;
    color: #fff !important;
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover:not(.current) {
    background: #f1f5f9 !important;
    color: #1a1a2e !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
    color: #cbd5e1 !important;
    cursor: not-allowed;
}

/* Responsive */
@media (max-width: 768px) {
    .header-card {
        padding: 20px;
    }
    
    .header-card .page-title {
        font-size: 22px;
    }
    
    .header-stats {
        gap: 12px;
    }
    
    .action-bar {
        flex-direction: column;
        align-items: stretch;
    }
    
    .export-btn {
        justify-content: center;
    }
    
    .dataTables_wrapper .dataTables_filter input {
        min-width: 100%;
    }
    
    .doc-link {
        padding: 4px 8px;
        font-size: 10px;
    }
    
    .view-btn {
        width: 32px;
        height: 32px;
    }
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 60px 20px;
}

.empty-state i {
    font-size: 60px;
    color: #cbd5e1;
    margin-bottom: 15px;
}

.empty-state h5 {
    color: #64748b;
    font-weight: 600;
    margin-bottom: 5px;
}

.empty-state p {
    color: #94a3b8;
}
</style>
@endsection

@section('content')

    <!-- Modern Loader Overlay -->
    <div id="loaderOverlay">
        <div class="loader-spinner"></div>
        <div class="loader-title">Chargement des dossiers...</div>
        <div id="loaderSubtext" class="loader-subtitle">Préparation des données</div>
        <div class="loader-progress-container">
            <div id="loaderProgressBar" class="loader-progress-bar"></div>
        </div>
    </div>

    <!-- Header Card -->
    <div class="header-card">
        <h2 id="title" class="page-title">Dossiers</h2>
        <div class="header-stats">
            <div class="stat-item">
                <span class="stat-label">Total:</span>
                <span id="statTotal" class="stat-value">0</span>
            </div>
            <div class="stat-item">
                <span class="stat-label">Chargés:</span>
                <span id="statLoaded" class="stat-value success">0</span>
            </div>
            <div class="stat-item" id="statPending" style="display: none;">
                <span class="stat-label">En attente:</span>
                <span id="statPendingValue" class="stat-value pending">0</span>
            </div>
        </div>
    </div>

    <!-- Action Bar -->
    <div class="action-bar">
        <button class="export-btn" onclick="exportToExcel()">
            <i class="uil uil-file-export"></i>
            Exporter Excel
        </button>
      <div id="loadProgress" class="load-progress">
    <div class="progress-status">
        <div class="progress-spinner"></div>
        <i class="uil uil-check progress-check hidden" style="color: #10b981; font-size: 20px;"></i>
    </div>
    <span id="progressText" class="progress-text">Chargement...</span>
</div>
        
    </div>

    <!-- Table Card -->
    <div class="table-card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table" id="myTable">
                    <thead>
                        <tr>
                            <th>Reference Dossier</th>
                            <th>Compagnie</th>
                            <th>Assuré</th>
                            <th>Matricule</th>
                            <th>N° Sinistre</th>
                            <th>Type</th>
                            <th>Mode</th>
                            <th>Mt. Devis</th>
                            <th>Mt. Facture</th>
                            <th>Etape</th>
                            <th>Délai</th>
                            <th>Status</th>
                            <th>Documents</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="tableBody">
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Hidden Inputs -->
    <input type="hidden" id="role" value="{{ Auth::user()->role_id }}">
    <input type="hidden" id="currentFilter" value="default">

@endsection

@section('script')
<!-- Add SheetJS from CDN -->
<script src="https://cdn.sheetjs.com/xlsx-0.20.0/package/dist/xlsx.full.min.js"></script>
<script>
(function() {
    "use strict";

    // Configuration - OPTIMIZED FOR FAST FIRST LOAD
    var CONFIG = {
        INITIAL_LOAD: 100,  // Only 100 records on first load for speed
        BATCH_SIZE: 500,    // Load more in background when needed
        API_URL: "/api/dossiers/data",
        EXPORT_URL: "/export/dossiers",
        CSRF_TOKEN: document.querySelector("meta[name=csrf-token]") ? document.querySelector("meta[name=csrf-token]").getAttribute("content") : ""
    };

    // State
    var State = {
        currentFilter: "default",
        allData: [],
        totalRecords: 0,
        isLoading: false,
        isFullyLoaded: false,
        dataTable: null
    };

    // Filter mapping
    var FILTER_MAP = {
        "/Expertiser": "expertiser",
        "/Expertise/encours": "enexp",
        "/Reporter": "areport",
        "/Devis/Carence": "carencedevis",
        "/Facture/Carence": "carencefacture",
        "/Carence/Rapport": "carencerapport",
        "/Devis/Retraiter": "devisretraiter",
        "/Facture/Retraiter": "factureretraiter",
        "/Retraiter/Rapport": "rapportaretraiter",
        "/Devis/Traitement": "traitdevis",
        "/Facture/Traitement": "traitfacture",
        "/Signer/Rapport": "rapportasigner",
        "/Instance/Rapport": "traitrapport",
        "/Devis/Envoyer": "senddevis",
        "/Facture/Envoyer": "sendfacture",
        "/Envoyer/Rapport": "sendrapport",
        "/Devis/Avis": "avisdevis",
        "/Facture/Avis": "avisfacture",
        "/Devis/Deuxieme": "deuxdevis",
        "/Facture/Deuxieme": "deuxfacture",
        "/Deuxieme/Rapport": "deuxrapport",
        "/Douteux": "douteux",
        "/Tribunale": "tribunale",
        "/Warning": "warning",
        "/Signer/Document": "docasigner",
        "/Signe/Document": "docsigner",
        "/Rapide": "rapide",
        "/Base": "basedoc",
        "/Facturation": "facturation",
        "/Devis/Trait": "devisentraitement",
        "/Facture/Trait": "factureentraitement",
        "/Devis/Photo": "attdevisav",
        "/Facture/Photo": "attfactureap",
        "/Expertise/Apres": "attexpap",
        "/Devis/Controler": "controldevis"
    };

    // DataTable language config
    var DT_LANGUAGE = {
        lengthMenu: "Afficher _MENU_ entrées",
        zeroRecords: "Aucun dossier trouvé",
        info: "Affichage de _START_ à _END_ sur _TOTAL_ entrées",
        infoEmpty: "Aucune entrée disponible",
        infoFiltered: "(filtré de _MAX_ entrées totales)",
        search: "Rechercher:",
        paginate: {
            first: "Premier",
            last: "Dernier",
            next: "Suivant",
            previous: "Précédent"
        }
    };

    // UI Functions
    function showLoader() {
        document.getElementById("loaderOverlay").classList.remove("hidden");
    }

    function hideLoader() {
        document.getElementById("loaderOverlay").classList.add("hidden");
    }

    function updateLoaderProgress(percent, text) {
        document.getElementById("loaderProgressBar").style.width = percent + "%";
        if (text) document.getElementById("loaderSubtext").textContent = text;
    }

    function updateStats(total, loaded) {
        document.getElementById("statTotal").textContent = total.toLocaleString('fr-FR');
        document.getElementById("statLoaded").textContent = loaded.toLocaleString('fr-FR');
        var pending = total - loaded;
        if (pending > 0) {
            document.getElementById("statPending").style.display = "flex";
            document.getElementById("statPendingValue").textContent = pending.toLocaleString('fr-FR');
        } else {
            document.getElementById("statPending").style.display = "none";
        }
    }

    // Format table row - REDESIGNED
    function formatRow(v) {
        var html = "";
        
        // Row class for updated items
        if (v.is_updated == 1) {
            html += "<tr class=\"table-success\">";
        } else {
            html += "<tr>";
        }
        
        // Reference
        html += "<td class=\"ref-cell\">" + (v.ref || "-") + "</td>";
        
        // Company
        html += "<td>" + (v.company || "-") + "</td>";
        
        // Insured Name
        html += "<td><strong>" + (v.insured_name || "-") + "</strong></td>";
        
        // Matricule
        html += "<td>" + (v.matricule || "-") + "</td>";
        
        // N° Sinistre
        html += "<td>" + (v.numero_sinistre || "-") + "</td>";
        
        // Type
        html += "<td><span class=\"badge badge-type\">" + (v.type_expertise || "-") + "</span></td>";
        
        // Mode
        html += "<td><span class=\"badge badge-mode\">" + (v.mode || "-") + "</span></td>";
        
        // Montant Devis
        html += "<td><span class=\"badge badge-amount\">" + (v.montant_devis || "-") + "</span></td>";
        
        // Montant Facture
        html += "<td><span class=\"badge badge-amount\">" + (v.montant_facture || "-") + "</span></td>";
        
        // Step
        html += "<td><span class=\"badge badge-step\">" + (v.step || "-") + "</span></td>";
        
        // Time Left
        if (v.timeleft > 0) {
            html += "<td><span class=\"badge badge-time positive\">" + v.timeleft + "H</span></td>";
        } else {
            html += "<td><span class=\"badge badge-time negative\">" + v.timeleft + "H</span></td>";
        }
        
        // Status
        html += "<td><span class=\"badge bg-" + (v.status_color || "secondary") + "\">" + (v.status || "-") + "</span></td>";
        
        // Document Links (combined into one cell)
        html += "<td>";
        html += "<div class=\"action-links\">";
        html += "<a href=\"Devis/Dossier/" + v.id + "\" class=\"doc-link devis\">Devis</a>";
        html += "<a href=\"Rapport/" + v.id + "\" class=\"doc-link rapport\">Rapport</a>";
        html += "<a href=\"Dossier/" + v.id + "/Facture\" class=\"doc-link facture\">Facture</a>";
        html += "</div>";
        html += "</td>";
        
        // Action - View Button
        html += "<td>";
        html += "<a href=\"Dossier/" + v.id + "\" class=\"view-btn\" title=\"Voir le dossier\">";
        html += "<i class=\"uil uil-eye\"></i>";
        html += "</a>";
        html += "</td>";
        
        html += "</tr>";
        return html;
    }

    // Safely destroy DataTable
    function destroyDataTable() {
        try {
            if ($.fn.DataTable && $.fn.DataTable.isDataTable("#myTable")) {
                $("#myTable").DataTable().destroy();
            }
        } catch (e) {
            console.log("DataTable destroy warning:", e);
        }
        State.dataTable = null;
    }

    // Initialize DataTable with events
    function initDataTable() {
        State.dataTable = $("#myTable").DataTable({
            paging: true,
            pageLength: 25,
            lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Tout"]],
            ordering: true,
            order: [[0, "desc"]],
            searching: true,
            info: true,
            autoWidth: false,
            language: DT_LANGUAGE,
            dom: '<"top"lf>rt<"bottom"ip><"clear">'
        });

        // Bind events
        State.dataTable.on("page.dt", function() {
            if (!State.isFullyLoaded && State.allData.length < State.totalRecords) {
                loadRemaining();
            }
        });

        State.dataTable.on("length.dt", function(e, settings, len) {
            if (!State.isFullyLoaded && State.allData.length < State.totalRecords) {
                if (len > State.allData.length || len === -1) {
                    loadRemaining();
                }
            }
        });
    }

    // Build table body HTML
    function buildTableBody() {
        var tbody = document.getElementById("tableBody");
        var html = "";
        for (var i = 0; i < State.allData.length; i++) {
            html += formatRow(State.allData[i]);
        }
        tbody.innerHTML = html;
    }

    // Fetch data from API
    function fetchBatch(filter, start, length, callback) {
        var xhr = new XMLHttpRequest();
        var params = "filter=" + encodeURIComponent(filter) + "&start=" + start + "&length=" + length + "&draw=1";
        xhr.open("GET", CONFIG.API_URL + "?" + params, true);
        xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    try {
                        callback(null, JSON.parse(xhr.responseText));
                    } catch (e) {
                        callback(e, null);
                    }
                } else {
                    callback(new Error("Network error: " + xhr.status), null);
                }
            }
        };
        xhr.send();
    }

    // Load initial data - OPTIMIZED FOR SPEED
    function loadInitial(filter) {
        // Reset progress bar to loading state
var spinner = document.querySelector('.progress-spinner');
var check = document.querySelector('.progress-check');
if (spinner && check) {
    spinner.classList.remove('hidden');
    check.classList.add('hidden');
    document.getElementById("progressText").textContent = "Chargement...";
    document.getElementById("loadProgress").style.display = "flex";
}
        State.isLoading = true;
        State.isFullyLoaded = false;
        State.allData = [];
        State.currentFilter = filter;

        showLoader();
        updateLoaderProgress(30, "Chargement rapide...");

        // Request only 100 records for fast first display
        fetchBatch(filter, 0, CONFIG.INITIAL_LOAD, function(err, result) {
            if (err) {
                console.error("Error loading data:", err);
                hideLoader();
                alert("Erreur lors du chargement des données");
                State.isLoading = false;
                return;
            }

            State.allData = result.data || [];
            State.totalRecords = result.recordsTotal || 0;

            updateLoaderProgress(90, "Affichage...");
            
            renderTable();
            updateStats(State.totalRecords, State.allData.length);

            // Check if we have all data or need to load more
           if (State.allData.length >= State.totalRecords) {
    State.isFullyLoaded = true;
    
    // Show success state briefly
    var spinner = document.querySelector('.progress-spinner');
    var check = document.querySelector('.progress-check');
    var text = document.getElementById("progressText");
    
    spinner.classList.add('hidden');
    check.classList.remove('hidden');
    text.textContent = "Chargement terminé ! (" + 
        State.allData.length.toLocaleString('fr-FR') + " dossiers)";
    
    // Auto-hide after 1.5 seconds
    setTimeout(function() {
        document.getElementById("loadProgress").style.display = "none";
    }, 1500);
} else {
                // Show load more indicator
                document.getElementById("loadProgress").style.display = "flex";
                var remaining = State.totalRecords - State.allData.length;
                document.getElementById("progressText").textContent = remaining.toLocaleString('fr-FR') + " dossiers restants - Naviguez pour charger plus";
            }

            updateLoaderProgress(100, "Terminé!");
            setTimeout(hideLoader, 200); // Faster hide
            State.isLoading = false;
        });
    }

    // Load remaining data in background
    function loadRemaining() {
        if (State.isFullyLoaded || State.isLoading) return;
        if (State.allData.length >= State.totalRecords) {
            State.isFullyLoaded = true;
            return;
        }

        State.isLoading = true;
        document.getElementById("loadProgress").style.display = "flex";

        function loadNextBatch() {
            if (State.allData.length >= State.totalRecords) {
                State.isFullyLoaded = true;
                State.isLoading = false;
                document.getElementById("statPending").style.display = "none";
                // Show checkmark & final message
document.querySelector('.progress-spinner').classList.add('hidden');
document.querySelector('.progress-check').classList.remove('hidden');
document.getElementById("progressText").textContent = "Chargement terminé ! (" + 
    State.allData.length.toLocaleString('fr-FR') + " dossiers)";
                refreshTable();
                return;
            }

            var pct = Math.round((State.allData.length / State.totalRecords) * 100);
            document.getElementById("progressText").textContent = State.allData.length.toLocaleString('fr-FR') + " / " + State.totalRecords.toLocaleString('fr-FR') + " (" + pct + "%)";

            fetchBatch(State.currentFilter, State.allData.length, CONFIG.BATCH_SIZE, function(err, result) {
                if (err || !result.data || result.data.length === 0) {
                    State.isFullyLoaded = true;
                    // Show checkmark & final message
document.querySelector('.progress-spinner').classList.add('hidden');
document.querySelector('.progress-check').classList.remove('hidden');
document.getElementById("progressText").textContent = "Terminé ! (" + 
    State.allData.length.toLocaleString('fr-FR') + " dossiers)";
                    refreshTable();
                    return;
                }

                State.allData = State.allData.concat(result.data);
                updateStats(State.totalRecords, State.allData.length);
                loadNextBatch();
            });
        }

        loadNextBatch();
    }

    // Refresh table with new data
    function refreshTable() {
        var currentPage = 0;
        var currentSearch = "";

        if (State.dataTable) {
            try {
                currentPage = State.dataTable.page();
                currentSearch = State.dataTable.search();
            } catch (e) {}
        }

        destroyDataTable();
        buildTableBody();
        initDataTable();

        if (currentSearch) {
            State.dataTable.search(currentSearch).draw(false);
        }
        
        var totalPages = State.dataTable.page.info().pages;
        if (currentPage > 0 && currentPage < totalPages) {
            State.dataTable.page(currentPage).draw(false);
        }
    }

    // Render table (initial)
    function renderTable() {
        destroyDataTable();
        buildTableBody();
        initDataTable();
    }

    // Load data for sidebar filter
    function loadData(url, title) {
        var filter = FILTER_MAP[url] || "default";
        State.currentFilter = filter;
        document.getElementById("currentFilter").value = filter;
        document.getElementById("title").textContent = title;
        loadInitial(filter);
    }

    // Export to Excel
   function exportToExcel() {
    if (!State.dataTable) {
        alert("Aucune donnée à exporter.");
        return;
    }

    try {
        // Get visible rows data (as objects, respecting current order & search)
        var data = State.dataTable.rows({ search: 'applied' }).data().toArray();

        if (data.length === 0) {
            alert("Aucun dossier visible à exporter.");
            return;
        }

        // Map to desired columns (skip Documents & Action)
        var exportData = data.map(function(row) {
            // row is an object (if using objects) OR array (if using arrays)
            // Since you built HTML manually, DataTables stores as array by default
            // Let's assume array order matches <th> order:
            // [0]Reference, [1]Compagnie, [2]Assuré, [3]Matricule, [4]Sinistre,
            // [5]Type, [6]Mode, [7]Mt. Devis, [8]Mt. Facture, [9]Etape, [10]Délai, [11]Status
            
            return {
                "Référence": row[0] || "",
                "Compagnie": row[1] || "",
                "Assuré": row[2] || "",
                "Matricule": row[3] || "",
                "N° Sinistre": row[4] || "",
                "Type": row[5] ? $(row[5]).text().trim() : "",        // Extract text from badge
                "Mode": row[6] ? $(row[6]).text().trim() : "",
                "Mt. Devis": row[7] ? $(row[7]).text().trim() : "",
                "Mt. Facture": row[8] ? $(row[8]).text().trim() : "",
                "Étape": row[9] ? $(row[9]).text().trim() : "",
                "Délai": row[10] ? $(row[10]).text().trim() : "",    // e.g., "12H"
                "Statut": row[11] ? $(row[11]).text().trim() : ""
            };
        });

        // Convert to worksheet
        var ws = XLSX.utils.json_to_sheet(exportData);

        // Auto-fit column width (optional but nice)
        var colWidths = Object.keys(exportData[0]).map(key => ({
            wch: Math.max(10, key.length + 2) // min 10, based on header + padding
        }));
        ws['!cols'] = colWidths;

        // Create workbook
        var wb = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(wb, ws, "Dossiers");

        // Generate & download
        var filename = "Dossiers_" + new Date().toISOString().slice(0,10) + ".xlsx";
        XLSX.writeFile(wb, filename);

    } catch (e) {
        console.error("Export error:", e);
        alert("Erreur lors de l'export Excel : " + (e.message || e));
    }
}
    // Bind sidebar events
    function bindSidebarEvents() {
        var bindings = {
            "collapse1": ["/Expertiser", "Attente Photo Avant"],
            "collapse92": ["/Expertise/encours", "Dossier En Expertise"],
            "collapse95": ["/Instance/Rapport", "Instance Rapport"],
            "collapse2": ["/Devis/Carence", "Attente Devis"],
            "collapse3": ["/Facture/Carence", "Attente Facture"],
            "collapse4": ["/Carence/Rapport", "Attente Rapport"],
            "collapse13": ["/Devis/Envoyer", "Accord Devis"],
            "collapse14": ["/Facture/Envoyer", "Accord Facture"],
            "collapse15": ["/Envoyer/Rapport", "Rapport A Envoyer"],
            "collapse15b": ["/Envoyer/Rapport", "Rapport A Envoyer"],
            "collapse16": ["/Devis/Deuxieme", "2ème Devis"],
            "collapse17": ["/Facture/Deuxieme", "2ème Facture"],
            "collapse05": ["/Deuxieme/Rapport", "Rapport Refusé"],
            "collapse90": ["/Facture/Trait", "Facture en Attente Accord"],
            "collapse91": ["/Devis/Trait", "Devis en Attente Accord"],
            "collapse72": ["/Base", "Attente Doc de Base"],
            "collapse50": ["/Signer/Document", "Documents A Signer"],
            "collapse80": ["/Devis/Photo", "Devis Sans Photo"],
            "collapse81": ["/Facture/Photo", "Facture Sans Photo"],
            "collapse96": ["/Expertise/Apres", "Attente Photo Après"],
            "collapse5": ["/Devis/Retraiter", "Devis A Retraiter"],
            "collapse6": ["/Facture/Retraiter", "Facture A Retraiter"],
            "collapse77": ["/Devis/Traitement", "Devis A Traiter"],
            "collapse9": ["/Facture/Traitement", "Facture A Traiter"],
            "collapse93": ["/Devis/Controler", "Devis A Contrôler"],
            "collapse8": ["/Signer/Rapport", "Rapport A Signer"],
            "collapse10": ["/Devis/Avis", "Demande Avis Devis"],
            "collapse11": ["/Facture/Avis", "Demande Avis Facture"],
            "collapse20": ["/Douteux", "Sinistre Douteux"],
            "collapse21": ["/Tribunale", "Dossier Tribunale"],
            "collapse85": ["/Facturation", "Dossier A Facturer"],
            "collapse71": ["/Rapide", "Dossier Rapide"],
            "collapse88": ["/Signe/Document", "Documents Signés"],
            "collapse7": ["/Retraiter/Rapport", "Rapport A Retraiter"]
        };

        for (var id in bindings) {
            (function(elemId, url, title) {
                var el = document.getElementById(elemId);
                if (el) {
                    el.addEventListener("click", function(e) {
                        e.preventDefault();
                        loadData(url, title);
                    });
                    el.style.cursor = "pointer";
                }
            })(id, bindings[id][0], bindings[id][1]);
        }
    }

    // Initialize on DOM ready
    $(document).ready(function() {
        destroyDataTable();
        bindSidebarEvents();
        loadInitial("default");
    });

    // Expose globally
    window.loadData = loadData;
    window.exportToExcel = exportToExcel;

})();
</script>
@endsection