@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('Substitute.store') }}" method="post">
                            @csrf
                                <div class="form-group mb-1">
                                    <label for="Role">Utilisateurs</label>
                                    <input type="text" class="form-control"  readonly value="{{ $user->name }}">
                                    <input type="hidden" name="user_id" value="{{ $user->id }}">
                                </div>
                                <div class="form-group mb-1">
                                    <label for="substitute_id">Remplacent</label>
                                    <select class="form-select " name="substitute_id"
                                        id="substitute_id">
                                        @if ($sub)
                                        <option value="{{ $sub->id }}">{{ $sub->name }}</option>
                                        @else
                                        <option value="">Selectionner Un Remplacant</option>
                                        @endif
                                        @foreach ($substitutes as $sub)
                                            <option value="{{ $sub->id }}">{{ $sub->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Remplacer</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

@endsection
