@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">

        <div class="row mb-3">
            <form action="{{ route('Ticket.update', $ticket->id) }}" method="post">
                @csrf
                @method('PUT')
                <div class="col-12">
                    <div class="page-title-box">
                        {{-- @if (is_null($check)) --}}
                        <div class="page-title-left">
                            <button name="action" value="annuler" class="mt-2 btn btn-danger ">Annuler</button>
                            <button name="action" value="terminer" class="mt-2 btn btn-success">Terminer</button>

                        </div>


                    </div>
                </div>
                <div class="col-12 mt-2">

                    <div class="form-group mb-1">
                        <label for="user">Réponse :</label>
                        <textarea name="answer" class="form-control @error('answer') is-invalid @enderror" id="" cols="10"
                            rows="10"></textarea>
                        @error('answer')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                </div>
            </form>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Dossier</th>

                                        <th>Reclameur</th>
                                        <th>Utilisateur</th>
                                        <th>Status</th>
                                        <th>Date Reponse</th>
                                        <th>Date Creation</th>
                                        <th>Afficher</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><a href="{{ route('Dossier.show',$ticket->dossier_id) }}">{{ $ticket->dossier->ref }}</a></td>

                                        <td>{{ $ticket->creator->name }}</td>
                                        <td>{{ $ticket->user->name }}</td>
                                        <td>{{ $ticket->status->status }}</td>
                                        <td>{{ $ticket->answer_at }}</td>
                                        <td>{{ $ticket->created_at }}</td>

                                        <td> <a class="btn btn-sm btn-info rounded-pill"
                                                href="{{ route('Ticket.show', [$ticket->id]) }}"><i
                                                    class="uil uil-eye fs-5"></i></a>
                                        </td>



                                    </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
