@extends('layouts.config_dashboard.app')

@section('content')
<div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <a style="float: left" href="{{ route('Operation.create') }}"
                                        class="btn btn-success rounded-pill"> Créer </a>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Operation Piece</th>
                                        <th>Modifier</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($operations as $operation)
                                        <tr>
                                            <td>{{ $operation->id }}</td>
                                            <td>{{ $operation->operation }}</td>
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Operation.edit', $operation->id) }}">
                                                    <i
                                                        class="uil uil-pen fs-5">
                                                    </i>
                                                </a>
                                            </td>

                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
