@extends('layouts.dashboard.app')
@section('style')
    <style>
        #description {
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
        }

        #infowindow-content .title {
            font-weight: bold;
        }

        #infowindow-content {
            display: none;
        }

        #map #infowindow-content {
            display: inline;
        }

        .pac-card {
            background-color: #fff;
            border: 0;
            border-radius: 2px;
            box-shadow: 0 1px 4px -1px rgba(0, 0, 0, 0.3);
            margin: 10px;
            padding: 0 0.5em;
            font: 400 18px Roboto, Arial, sans-serif;
            overflow: hidden;
            font-family: Roboto;
            padding: 0;
        }

        #pac-container {
            padding-bottom: 12px;
            margin-right: 12px;
        }

        .pac-controls {
            display: inline-block;
            padding: 5px 11px;
        }

        .pac-controls label {
            font-family: Roboto;
            font-size: 13px;
            font-weight: 300;
        }

        #pac-input {
            background-color: #fff;
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
            margin-left: 12px;
            padding: 0 11px 0 13px;
            text-overflow: ellipsis;
            width: 400px;
        }

        #pac-input:focus {
            border-color: #4d90fe;
        }

        #title {
            color: #fff;
            background-color: #4d90fe;
            font-size: 25px;
            font-weight: 500;
            padding: 6px 12px;
        }

        #target {
            width: 345px;
        }
    </style>
@endsection
@section('content')
    <div class="container-fluid mt-2 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('Garage.store') }}" method="post">
                            @csrf
                            <div class="form-group mb-2">
                                <label for="libelle">Libelle</label>
                                <input type="text" name="libelle" value="{{ old('libelle') }}" required
                                    class="form-control @error('libelle') is-invalid @enderror">
                                @error('libelle')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-2">
                                <label for="email">Email</label>
                                <input type="email" name="email" value="{{ old('email') }}" required
                                    class="form-control @error('email') is-invalid @enderror">
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="form-group mb-2">
                                <label for="city">Ville</label>
                                <select class="form-select " name="city" id="city">
                                    @foreach ($cities as $city)
                                        <option value="{{ $city->id }}">{{ $city->city }}</option>
                                    @endforeach
                                </select>

                            </div>

                            <div class="form-group mb-2">
                                <label for="adress">Adresse</label>
                                <input type="text" name="adress" value="{{ old('adress') }}"
                                    class="form-control @error('adress') is-invalid @enderror">
                                @error('adress')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class=" form-group mb-3">
                                <label for="simpleinput" class="form-label">Telephone </label>
                                <input type="text" id="tel" name="tel" value="{{ old('tel') }}"
                                    pattern="(\+212|0)([ \-_/]*)(\d[ \-_/]*){9}"
                                    class="form-control @error('tel') is-invalid  @enderror">
                                @error('tel')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="row">
                                <div class="col-md-6">

                                    <div class="form-group mb-2">
                                        <label for="url">Lien</label>
                                        <input type="text" id="url" name="url" value="{{ old('url') }}"
                                            class="form-control @error('url') is-invalid @enderror">
                                        @error('url')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                {{-- <div class="form-group mb-1">
                                    <div class="form-check form-check-inline form-checkbox">
                                        <input type="checkbox" class="form-check-input"
                                            name="verified">
                                        <label class="form-check-label fs-4"
                                            for="customSwitch3">Agréer</label>
                                    </div>
                                </div> --}}
                            </div>
                            <div class="row">
                                <div class="col-md-6">

                                    <div class="form-group mb-2">
                                        <label for="lng">Longitude</label>
                                        <input type="text" id="lng" name="lng" value="{{ old('lng') }}"
                                            class="form-control @error('lng') is-invalid @enderror">
                                        @error('lng')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group mb-2">
                                        <label for="lat">Lattitude</label>
                                        <input type="text" id="lat" name="lat" value="{{ old('lat') }}"
                                            class="form-control @error('lat') is-invalid @enderror">
                                        @error('lat')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <h4 class="header-title mb-3">Localisation :</h4>
                            <div class="col-md-12">
                                <input id="pac-input" class="controls" type="text" placeholder="Search Box" />
                                <div id="map" class="gmaps" style="height: 60vh">
                                </div>
                            </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Créer</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<!-- Leaflet Control Geocoder (search box) -->
<link rel="stylesheet" href="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.css" />

<style>
    #map { height: 60vh; width: 100%; }
    .leaflet-control-geocoder-form input {
        font-size: 15px !important;
        height: 40px;
    }
</style>

<div class="col-md-12 mb-3">
    <input id="search-box" type="text" class="form-control" placeholder="Rechercher une adresse..." />
    <div id="map"></div>
</div>

<!-- Leaflet JS -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<!-- Leaflet Control Geocoder (Nominatim = OpenStreetMap search) -->
<script src="https://unpkg.com/leaflet-control-geocoder/dist/Control.Geocoder.js"></script>

<script>
    // Initialize the map (center on Morocco by default)
    const map = L.map('map').setView([31.7917, -7.0926], 6);

    // OpenStreetMap tiles (completely free)
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);

    // Draggable marker
    let marker = L.marker([33.5731, -7.5898], { draggable: true }).addTo(map);

    // Update lat/lng fields when marker is dragged
    marker.on('dragend', function(e) {
        const position = marker.getLatLng();
        $('#lat').val(position.lat.toFixed(8));
        $('#lng').val(position.lng.toFixed(8));
    });

    // Click on map → move marker
    map.on('click', function(e) {
        marker.setLatLng(e.latlng);
        $('#lat').val(e.latlng.lat.toFixed(8));
        $('#lng').val(e.latlng.lng.toFixed(8));
    });

    // Add search box (using free OpenStreetMap Nominatim)
    L.Control.geocoder({
        defaultMarkGeocode: false,
        placeholder: "Rechercher une adresse...",
        errorMessage: "Aucun résultat trouvé",
        geocoder: L.Control.Geocoder.nominatim()
    })
    .on('markgeocode', function(e) {
        const latlng = e.geocode.center;
        marker.setLatLng(latlng);
        map.setView(latlng, 16);

        $('#lat').val(latlng.lat.toFixed(8));
        $('#lng').val(latlng.lng.toFixed(8));
    })
    .addTo(map);

    // Optional: move existing search input to use Leaflet's built-in one
    document.getElementById('pac-input').style.display = 'none'; // hide old Google input
</script>
@endsection