<?php

namespace App\Observers;

use App\Models\Meeting;
use App\Models\Notification;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class MeetingObserver
{
    /**
     * Handle the Meeting "created" event.
     *
     * @param  \App\Models\Meeting  $meeting
     * @return void
     */
    public function created(Meeting $meeting)
    {
        $body = "A Creer un nouveau meeting Ref :".$meeting->dossier->ref ;
        Notification::create([
            'user_id'=>Auth::user()->id,
            'dossier_id'=>$meeting->dossier->id,
            'body'=>$body
        ]);

        $url = 'https://fcm.googleapis.com/fcm/send';


        if($meeting->type == 2){
            $notif ="Vous Avez Reçu un Nouveau Meeting à Consultez pour Photo Avant Ref: ".$meeting->dossier->ref;
        }
        else if($meeting->type == 5){
            $notif ="Vous Avez Reçu un Nouveau Meeting à Consultez pour Photo En Cours Ref: ".$meeting->dossier->ref;
        }
        else if($meeting->type == 10){
            $notif ="Vous Avez Reçu un Nouveau Meeting à Consultez pour Photo Aprés Ref: ".$meeting->dossier->ref;
        }
        else {
            $notif ="Vous Avez Reçu un Nouveau Meeting à Consultez pour Photo  Ref: ".$meeting->dossier->ref;
        }
        $user = User::whereId($meeting->user_id)->first();

        $user->sendFCMNotification($notif , $body);
        // $serverKey = 'AAAANCX6iT8:APA91bFYyrHReMJwPhAETNPgwYTZPt_s0sfpZWWvtIroQ1k4GmvQ9US8MDLF4Qp0YSXqSNo7hGtv0ozhni_-D7OoY6g7so6mgJXr6qhJZ3axZsBSAjEyiASo5ON6f5IGj7TomMEQH4da';

        // $data = [
        //     "registration_ids" =>$token,
        //     "notification" => [
        //         "title" => "Meeting Assigné ✅",
        //         "body" => $notif,
        //         "android_channel_id" => "nouveau_meeting",
        //         "notification_priority" => "PRIORITY_HIGH",
        //         "visibility" => "PUBLIC"
        //     ]
        // ];
        // $encodedData = json_encode($data);

        // $headers = [
        //     'Authorization:key=' . $serverKey,
        //     'Content-Type: application/json',
        // ];

        // $ch = curl_init();

        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        // curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        // // Disabling SSL Certificate support temporarly
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, $encodedData);
        // // Execute post
        // $result = curl_exec($ch);
        // if ($result === FALSE) {
        //     die('Curl failed: ' . curl_error($ch));
        // }
        // // Close connection
        // curl_close($ch);
        // dd($result);
    }

    /**
     * Handle the Meeting "updated" event.
     *
     * @param  \App\Models\Meeting  $meeting
     * @return void
     */
    public function updated(Meeting $meeting)
    {
        if($meeting->meeting_status_id  == 2){
            $body = "Meeting Modifier Ref :".$meeting->dossier->ref ;
            $notif ="Meeting  Modifier   Ref: ".$meeting->dossier->ref;
        }
        else if($meeting->meeting_status_id == 3)
        {
            $body = "Meeting Valider Ref :".$meeting->dossier->ref ;
            $notif ="Meeting  Valider   Ref: ".$meeting->dossier->ref;
        }else{
            $body = "Meeting Annuler Ref :".$meeting->dossier->ref ;
            $notif ="Meeting  Annuler   Ref: ".$meeting->dossier->ref;
        }
        Notification::create([
            'user_id'=>Auth::user()->id,
            'dossier_id'=>$meeting->dossier->id,
            'body'=>$body
        ]);



        // $url = 'https://fcm.googleapis.com/fcm/send';

         $user = User::whereId($meeting->user_id)->first();

         $user->sendFCMNotification( $notif , $body);

        // $token = [$FcmToken->device_key];

        // $serverKey = 'AAAANCX6iT8:APA91bFYyrHReMJwPhAETNPgwYTZPt_s0sfpZWWvtIroQ1k4GmvQ9US8MDLF4Qp0YSXqSNo7hGtv0ozhni_-D7OoY6g7so6mgJXr6qhJZ3axZsBSAjEyiASo5ON6f5IGj7TomMEQH4da';

        // $data = [
        //     "registration_ids" =>$token,
        //     "notification" => [
        //         "title" => "Meeting Assigné Modifier ✅",
        //         "body" => $notif,
        //         "android_channel_id" => "nouveau_meeting",
        //         "notification_priority" => "PRIORITY_HIGH",
        //         "visibility" => "PUBLIC"
        //     ]
        // ];
        // $encodedData = json_encode($data);

        // $headers = [
        //     'Authorization:key=' . $serverKey,
        //     'Content-Type: application/json',
        // ];

        // $ch = curl_init();

        // curl_setopt($ch, CURLOPT_URL, $url);
        // curl_setopt($ch, CURLOPT_POST, true);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        // curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        // // Disabling SSL Certificate support temporarly
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // curl_setopt($ch, CURLOPT_POSTFIELDS, $encodedData);
        // // Execute post
        // $result = curl_exec($ch);
        // if ($result === FALSE) {
        //     die('Curl failed: ' . curl_error($ch));
        // }
        // // Close connection
        // curl_close($ch);
    }

    /**
     * Handle the Meeting "deleted" event.
     *
     * @param  \App\Models\Meeting  $meeting
     * @return void
     */
    public function deleted(Meeting $meeting)
    {
        //
    }

    /**
     * Handle the Meeting "restored" event.
     *
     * @param  \App\Models\Meeting  $meeting
     * @return void
     */
    public function restored(Meeting $meeting)
    {
        //
    }

    /**
     * Handle the Meeting "force deleted" event.
     *
     * @param  \App\Models\Meeting  $meeting
     * @return void
     */
    public function forceDeleted(Meeting $meeting)
    {
        //
    }
}
