<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Opponent extends Model
{
    use HasFactory;

    protected $fillable =['name','civility','telephone','matricule','company_id','vehicule_model_id','numero_attestation'];

    public function company() {

        return $this->belongsTo(Company::class)->withTrashed();
    }

    public function vehiculemodel(){

        return $this->belongsTo(VehiculeModel::class,'vehicule_model_id')->withTrashed();
    }

    public function dossier(){

        return $this->hasMany(Dossier::class)->withTrashed();
    }

}
