<?php

namespace App\Http\Controllers;

use App\Models\Devis;
use App\Models\Dossier;
use App\Models\Notification;
use App\Models\SignedUrl;
use App\Models\TypeDocument;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;

class SignedUrlController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $this->authorize('viewAny',SignedUrl::class);
        $types = TypeDocument::all();
        $array = [];
        foreach($types as $type){
            $newString = str_replace(' ', '_', $type->type);
            if($request[$newString] !== null){
                array_push($array,$type->id);
            }
        }
        $dossier = Dossier::whereId($request->dossier_id)->firstOrFail();
        $uid = uniqid();
         $signed =SignedUrl::create([
            'signature'=>$uid,
            'dossier_id'=>$dossier->id,
        ]);

        foreach($array as $type ){
            $doc = TypeDocument::whereId($type)->first();
            if($type == 8){
                $devis = Devis::where('dossier_id',$dossier->id)->where(function($query){
                    $query->where('devis_status_id',2)->Orwhere('devis_status_id',7);
                })->count();
                if($devis == 0 ){
                    return redirect()->back()->with('error', 'Pour Créer Une facture on a Besoin un Accord de Devis ');
                }

            }
            $signed->typedocument()->attach($doc);
        }

        $url = URL::temporarySignedRoute(
            'Carence.create',
            now()->addMinutes(30),
            ['dossier_id' => $dossier->id ,'token'=>$uid ]
        );
        $body = "A Generer un Lien Public  :" . $dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);


        return view('dossiers.url',compact('url','dossier'));

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SignedUrl  $signedUrl
     * @return \Illuminate\Http\Response
     */
    public function show(SignedUrl $signedUrl)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SignedUrl  $signedUrl
     * @return \Illuminate\Http\Response
     */
    public function edit(SignedUrl $signedUrl)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SignedUrl  $signedUrl
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SignedUrl $signedUrl)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SignedUrl  $signedUrl
     * @return \Illuminate\Http\Response
     */
    public function destroy(SignedUrl $signedUrl)
    {
        //
    }
}
