<?php

namespace App\Http\Controllers;

use App\Models\Dossier;
use App\Models\Rendezvous;
use App\Models\Step;
use App\Models\TypeRendezvous;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use PhpParser\Node\Stmt\Return_;

class RendezvousController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    /**
     * GET RDV
     */
    public function index()
    {
        $rdvs = Rendezvous::with('statusrendezvous', 'typerendezvous')->where('user_id',Auth::user()->id)->get();
        //dd($rdvs);
        return view('configuration.RendezVous.index', compact('rdvs'));
    }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


   

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Rendezvous  $rendezvous
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $rdv = Rendezvous::whereId($id)->with('statusrendezvous', 'typerendezvous')->first();
        return view('configuration.RendezVous.edit', compact('rdv'));
    }



    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Rendezvous  $rendezvous
     * @return \Illuminate\Http\Response
     */

    /**
     * Update RDV
     * @queryParam heure time required
     * @queryParam date date required
     */
    public function update(Request $request, $id)
    {
        $rdv = Rendezvous::whereId($id)->first();
        if ($rdv->status_rendezvous_id == 2) {
            if ($request->input('action') == "terminer") {
                $rdv->status_rendezvous_id = 3;
                $rdv->update();
            } else if ($request->input('action') == "annuler") {
                $rdv->status_rendezvous_id = 1;
                $rdv->update();
            }
        }

        return redirect()->route('RendezVous.index');

        // try {

        //     $validate = Validator::make(
        //         $request->all(),
        //         [
        //             'heure' => 'required|date_format:H:i',
        //             'date' => 'required|date',
        //         ]
        //     );

        //     if ($validate->fails()) {
        //         return response()->json([
        //             'status' => false,
        //             'message' => 'validation error',
        //             'errors' => $validate->errors()
        //         ], 401);
        //     }
        //     $rdv = Rendezvous::whereId($id)->firstOrFail();
        //     $rdv->heure = $request->heure;
        //     $rdv->date = $request->date;


        // } catch (\Throwable $th) {
        //     return response()->json([
        //         'status' => false,
        //         'message' => $th->getMessage()
        //     ], 500);
        // }


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Rendezvous  $rendezvous
     * @return \Illuminate\Http\Response
     */
    public function destroy(Rendezvous $rendezvous)
    {
    }
}
