<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TypeDocument extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable=['type'];

    public function document()
    {
        return $this->hasMany(Document::class);
    }

    public function signedurl()
    {
        return $this->belongsToMany(SignedUrl::class,'type_document_id');
    }

    public function email()
    {
        return $this->belongsToMany(TypeDocument::class,'typedocument_email','typedocument_id');
    }

    public function user()
    {
        return $this->belongsToMany(User::class,'user_typedocuments');
        
    }

}
