<?php

namespace App\Http\Controllers;

use App\Models\Dossier;
use App\Models\Notification;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $request->validate([
            'date' => 'nullable|date',
            'ref' => 'nullable|exists:dossiers,ref',
        ]);
        // if(!$request->date){
        //     return redirect()->route('notification.index');
        // }

        if (Auth::user()->role_id === 4) {

            $notifications = Notification::with('user', 'dossier')
                ->when($request->ref, function ($query) use ($request) {
                    $dossier = Dossier::where('ref', $request->ref)->firstOrFail();
                    return $query->where('dossier_id', $dossier->id);
                })
                ->when($request->date, function ($query) use ($request) {
                    return $query->whereDate('created_at', '=', $request->date);
                })
                ->latest()->paginate(10);
        } else
        {
            $dossiers = Dossier::user()->get();
            $array = [];
            foreach ($dossiers as $dossier) {
                array_push($array, $dossier->id);
            }
            $notifications = Notification::whereIn('dossier_id', $array)
            ->when($request->ref, function ($query) use ($request) {
                    $dossier = Dossier::where('ref', $request->ref)->firstOrFail();
                    return $query->where('dossier_id', $dossier->id);
                })
            ->when($request->date, function ($query) use ($request) {
                    return $query->whereDate('created_at', '=', $request->date);
                })
                ->with('user', 'dossier')
                ->latest()->paginate(10);
        }



        return view('configuration.Historique.index', compact('notifications'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function search(Request $request)
    {
        $request->validate([
            'date' => 'nullable|date',
            'ref' => 'nullable|exists:dossiers,ref',
        ]);
        // if(!$request->date){
        //     return redirect()->route('notification.index');
        // }

        if (Auth::user()->role_id === 4) {

            $notifications = Notification::with('user', 'dossier')
                ->when($request->ref, function ($query) use ($request) {
                    $dossier = Dossier::where('ref', $request->ref)->firstOrFail();
                    return $query->where('dossier_id', $dossier->id);
                })
                ->when($request->date, function ($query) use ($request) {
                    return $query->whereDate('created_at', '=', $request->date);
                })
                ->latest()->paginate(10);
        } else
        {
            $dossiers = Dossier::user()->get();
            $array = [];
            foreach ($dossiers as $dossier) {
                array_push($array, $dossier->id);
            }
            $notifications = Notification::whereIn('dossier_id', $array)->whereDate('created_at', '=', Carbon::today()->toDateString())->latest()->paginate(10);
        }



        return view('configuration.Historique.index', compact('notifications'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Notification  $notification
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $dossier = Dossier::whereId($id)->with('notification.user')->firstOrFail();
        return view('configuration.Historique.details', compact('dossier'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Notification  $notification
     * @return \Illuminate\Http\Response
     */
    public function edit(Notification $notification)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Notification  $notification
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Notification $notification)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Notification  $notification
     * @return \Illuminate\Http\Response
     */
    public function destroy(Notification $notification)
    {
        //
    }
}
