<?php

namespace App\Observers;

use App\Models\Document;
use App\Models\Notification;
use Illuminate\Support\Facades\Auth;

class DocumentObserver
{
    /**
     * Handle the Document "created" event.
     *
     * @param  \App\Models\Document  $document
     * @return void
     */
    public function created(Document $document)
    {
        $body="A Telecharger des documents";

        Notification::create([
            'user_id'=>Auth::user()->id,
            'dossier_id'=>$document->dossier->id,
            'body'=>$body
        ]);

    }

    /**
     * Handle the Document "updated" event.
     *
     * @param  \App\Models\Document  $document
     * @return void
     */
    public function updated(Document $document)
    {
        $body="A Modifier Un Document {{$document->typedocument->type}}";
        Notification::create([
            'user_id'=>Auth::user()->id,
            'dossier_id'=>$document->dossier->id,
            'body'=>$body
        ]);
    }

    /**
     * Handle the Document "deleted" event.
     *
     * @param  \App\Models\Document  $document
     * @return void
     */
    public function deleted(Document $document)
    {
        //
    }

    /**
     * Handle the Document "restored" event.
     *
     * @param  \App\Models\Document  $document
     * @return void
     */
    public function restored(Document $document)
    {
        //
    }

    /**
     * Handle the Document "force deleted" event.
     *
     * @param  \App\Models\Document  $document
     * @return void
     */
    public function forceDeleted(Document $document)
    {
        //
    }
}
