<div>
    <form action="{{ route('Dossier.update', $dossier->id) }}" method="post">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title mb-3">Dossier {{ $dossier->ref }}</h4>

                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Compagnie</th>
                                            <th>Garantie</th>
                                            <th>Date Sinistre</th>
                                            <th>Date Reception</th>
                                            <th>Type de Dossier</th>
                                            <th>Vehicule</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <select name="company" class="form-control" id="">
                                                    <option selected value="{{ $dossier->company->id ?? null }}">
                                                        {{ $dossier->company->company ?? null }}</option>
                                                    @foreach ($companies as $company)
                                                        <option selected value="{{ $company->id }}">
                                                            {{ $company->company }}</option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td>
                                                <select name="guarantee" class="form-control" id="">
                                                    <option selected value="{{ $dossier->guarantee->id ?? null }}">
                                                        {{ $dossier->guarantee->guarantee ?? null }}</option>
                                                    @foreach ($guarantees as $guarantee)
                                                        <option selected value="{{ $guarantee->id }}">
                                                            {{ $guarantee->guarantee }}</option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td>
                                                <input type="date" name="date_sinistre" class="form-control"
                                                    value="{{ $dossier->date_sinistre ?? null }}" id="date_sinistre">
                                            </td>
                                            <td>
                                                <input type="date" name="date_reception" class="form-control"
                                                    value="{{ $dossier->date_reception ?? null }}" id="date_reception">
                                            </td>
                                            <td>
                                                <select name="typedossier" class="form-control" id="">
                                                    <option selected value="{{ $dossier->typedossier->id }}">
                                                        {{ $dossier->typedossier->type }}</option>
                                                    @foreach ($types as $typedossier)
                                                        <option selected value="{{ $typedossier->id }}">
                                                            {{ $typedossier->type }}</option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td>{{ $dossier->vehiculemodel->name ?? null }}/{{ $dossier->vehiculemodel->brand->brand ?? null }}
                                            </td>


                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <!-- end table-responsive -->

                        </div>
                    </div>
                </div> <!-- end col -->


            </div>


            <div class="row mt-2">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">

                            <h4 class="header-title mb-3">Assuré</h4>

                            <div class="table-responsive">
                                <table class="table mb-0 ">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Civilité</th>
                                            <th>Nom </th>
                                            <th>Telephone</th>
                                            <th>Marque</th>
                                            <th>Model</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <input type="text" name="civility" class="form-control"
                                                    value="{{ $dossier->insured->civility ?? null }}" id="civility">
                                            </td>
                                            <td> <input type="text" name="name" class="form-control"
                                                    value="{{ $dossier->insured->name ?? null }}" id="name">
                                            </td>
                                            <td> <input type="text" name="telephone" class="form-control"
                                                    value="{{ $dossier->insured->telephone ?? null }}" id="telephone">
                                            </td>
                                            <td>

                                                    <select name="brand_id" id="brand_id"
                                                        class="form-control @error('brand_id') is-invalid @enderror"
                                                        wire:model="selectedBrand">
                                                        <option value="" selected>Selectionner une marque</option>
                                                        @foreach ($brands as $brand)
                                                            <option value="{{ $brand->id }}">{{ $brand->brand }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('brand_id')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                            </td>
                                            <td>
                                               <select name="vehicule_model_id" id="vehicule_model_id"
                                                        class="form-control @error('vehicule_model_id') is-invalid @enderror"
                                                        wire:model="vehicule_model_id">
                                                        <option value="" selected>Selectionner un model</option>
                                                        @if ($models)
                                                            @foreach ($models as $model)
                                                                <option value="{{ $model->id }}">{{ $model->name }}</option>
                                                            @endforeach
                                                        @endif

                                                        @error('vehicule_model_id')
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </select>
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                            <!-- end table-responsive -->
                            <!-- end col -->
                        </div>
                    </div>
                </div> <!-- end col -->

                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title mb-3">Adversaire</h4>
                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Civilité</th>
                                            <th>Nom Complet</th>
                                            <th>Matricule</th>
                                            <th>Telephone</th>
                                            <th>Marque && Vehicule</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <input type="text" name="civilityop" class="form-control"
                                                    value="{{ $dossier->opponent->civility ?? null }}" id="civility">
                                            </td>
                                            <td>
                                                <input type="text" name="nameop" class="form-control"
                                                    value="{{ $dossier->opponent->name ?? null }}" id="civility">
                                            </td>
                                            <td>
                                                <input type="text" name="matriculeop" class="form-control"
                                                    value="{{ $dossier->opponent->matricule ?? null }}" id="civility">
                                            </td>
                                            <td>
                                                <input type="text" name="telephoneop" class="form-control"
                                                    value="{{ $dossier->opponent->telephone ?? null }}" id="civility">
                                            </td>
                                            <td>
                                                <div class="mb-3 col-md-4">
                                                    <label for="brandop_id" class="form-label">Marque de la voiture</label>
                                                    <select name="brandop_id" id="brandop_id" class="form-control"
                                                        wire:model="selectedBrandop">
                                                        <option value="" selected>Selectionner une marque</option>
                                                        @foreach ($brands as $brand)
                                                            <option value="{{ $brand->id }}">{{ $brand->brand }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="mb-3 col-md-4">
                                                    <label for="vehicule_modelop_id" class="form-label">Model de la voiture</label>
                                                    <select name="vehicule_modelop_id" id="vehicule_modelop_id" wire:model="vehicule_modelop_id"
                                                        class="form-control @error('vehicule_modelop_id') is-invalid @enderror">
                                                        <option value="" selected>Selectionner un model</option>
                                                        @if ($modelsop)
                                                            @foreach ($modelsop as $model)
                                                                <option value="{{ $model->id }}">{{ $model->name }}</option>
                                                            @endforeach
                                                        @endif
                                                    </select>

                                                    @error('vehicule_modelop_id')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                </div>
                                            </td>
                                            <td>
                                                <select name="typedossier" class="form-control" id="">
                                                    <option selected value="{{ $dossier->typedossier->id }}">
                                                        {{ $dossier->typedossier->type }}</option>
                                                    @foreach ($types as $typedossier)
                                                        <option selected value="{{ $typedossier->id }}">
                                                            {{ $typedossier->type }}</option>
                                                    @endforeach
                                                </select>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row mt-2">

                <div class="col-lg-12">
                    <button style="float: right" class=" mr-2 btn btn-success">Modifier</button>
                </div>
            </div>
        </form>



</div>
