@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Civilité</th>
                                    <th>Nom Complet</th>
                                    <th>Email</th>
                                    <th>Email Pro</th>
                                    <th>Ville</th>
                                    <th>Role</th>
                                    <th>Remplacement</th>
                                    <th>Supprimer</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $user->id }}</td>
                                    <td>{{ $user->civility ?? null }}</td>
                                    <td>{{ $user->name ?? null }}</td>
                                    <td>{{ $user->email ?? null }}</td>
                                    <td>{{ $user->email_pro ?? null }}</td>
                                    <td>{{ $user->city->city ?? null }}</td>

                                    <td><span class="badge bg-info rounded-pill">{{ $user->role->role }}</span> </td>
                                    <td><a class="btn btn-sm btn-warning"
                                            href="{{ route('Substitute.show', $user->id) }}">Remplacer</a> </td>
                                    @can('delete', App\Models\User::class)
                                        <td>
                                            @if (Auth::user()->id != $user->id)
                                                <form action="{{ route('user.destroy', [$user->id]) }}" method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                        <i class="uil uil-trash fs-5"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </td>
                                    @endcan
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        @if ($user->role_id != 5)
            <form method="POST" action="{{ route('Permission.store', [$user->id]) }}">
                <div class="row">
                    @csrf
                    @if ($user->role_id == 2)
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="mr-2 mt-1">
                                        <h4>Assigner une Garantie</h4>
                                        <hr>
                                        @forelse ($guarantees as $guarantee)
                                            @if ($user->hasGuarantee($guarantee->guarantee))
                                                <div class="form-check form-check-inline form-checkbox-dark ">
                                                    <input type="checkbox" checked class="form-check-input"
                                                        value="{{ $guarantee->id }}" name="guarantee[]"
                                                        id="customSwitch3{{ $guarantee->id }}">
                                                    <label class="form-check-label fs-4"
                                                        for="customSwitch3{{ $guarantee->id }}">{{ $guarantee->guarantee }}</label>
                                                </div>
                                            @else
                                                <div class="form-check form-check-inline form-checkbox-secondary ">
                                                    <input type="checkbox" class="form-check-input"
                                                        value="{{ $guarantee->id }}" name="guarantee[]"
                                                        id="customSwitch3{{ $guarantee->id }}">
                                                    <label class="form-check-label fs-4"
                                                        for="customSwitch3{{ $guarantee->id }}">{{ $guarantee->guarantee }}</label>
                                                </div>
                                            @endif

                                        @empty
                                            <h5>Tableau Vide</h5>
                                        @endforelse
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if ($user->role_id == 2 || $user->role_id == 1 || $user->role_id == 4)
                        {{-- <div class="col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="mr-2 mt-1">
                                        <h4>Assigner un Type Expertise</h4>
                                        <hr>
                                        @forelse ($types as $type)
                                            @if ($user->hasType($type->type))
                                                <div class="form-check form-check-inline form-checkbox-danger ">
                                                    <input type="checkbox" checked class="form-check-input"
                                                        value="{{ $type->id }}" name="typeexpertise[]"
                                                        id="customSwitch3{{ $type->id }}">
                                                    <label class="form-check-label fs-4"
                                                        for="customSwitch3{{ $type->id }}">{{ $type->type }}</label>
                                                </div>
                                            @else
                                                <div class="form-check form-check-inline form-checkbox-info ">
                                                    <input type="checkbox" class="form-check-input"
                                                        value="{{ $type->id }}" name="typeexpertise[]"
                                                        id="customSwitch3{{ $type->id }}">
                                                    <label class="form-check-label fs-4"
                                                        for="customSwitch3{{ $type->id }}">{{ $type->type }}</label>
                                                </div>
                                            @endif

                                        @empty
                                            <h5>Tableau Vide</h5>
                                        @endforelse
                                    </div>
                                </div>
                            </div>
                        </div> --}}
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                    <h4>Assigner un Type Document</h4>
                                    <div class="row">
                                        @forelse ($typedocs as $type)
                                            @if ($user->hasTypeDocument($type->type))
                                                <div class="col-md-3">
                                                    <div
                                                        class="form-check form-check-inline form-switch form-checkbox-primary">
                                                        <input type="checkbox" checked class="form-check-input"
                                                            value="{{ $type->id }}" name="type[]"
                                                            id="customSwitch1{{ $type->id }}">
                                                        <label class="form-check-label fw-bold"
                                                            for="customSwitch1{{ $type->id }}">{{ $type->type }}</label>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="col-md-3">
                                                    <div class="form-check form-check-inline form-switch">
                                                        <input type="checkbox" class="form-check-input"
                                                            value="{{ $type->id }}" name="type[]"
                                                            id="customSwitch1{{ $type->id }}">
                                                        <label style="color: rgb(37, 37, 37)"
                                                            class="form-check-label fw-bold"
                                                            for="customSwitch1{{ $type->id }}">{{ $type->type }}</label>
                                                    </div>
                                                </div>
                                            @endif
                                        @empty
                                            <div class="col-md 12">
                                                <h5>Tableau Vide</h5>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>
                            </div>

                        </div>
                    @endif

                </div>
                <div class="row">

                    @if ($user->role_id == 2 || $user->role_id == 1 || $user->role_id == 4)
                        @forelse ($companies as $company)
                            <div class="col-md-12 m-2">

                                <div class="card">
                                    <div class="card-body">
                                        <hr>
                                        <div class="mr-2 mt-1">
                                            <div class="form-check form-check-inline form-checkbox-success ">
                                                <input type="checkbox" @if ($user->hasCompanyType($company->company)) checked @endif
                                                    class="form-check-input" value="{{ $company->id }}" name="company[]"
                                                    id="customSwitch3{{ $company->id }}">
                                                <label class="form-check-label fs-4"
                                                    for="customSwitch3{{ $company->id }}">{{ $company->company }}</label>
                                            </div>
                                            <hr>
                                            @forelse ($types as $type)
                                                @if ($user->hasTypeCompany($type->id, $company->id, $user->id))
                                                    <div class="form-check form-check-inline form-checkbox-danger ">
                                                        <input type="checkbox" checked class="form-check-input"
                                                            value="{{ $type->id }}"
                                                            name="typeexpertise[{{ $company->id }}][{{ $type->id }}]"
                                                            id="customSwitch3{{ $type->id }}">
                                                        <label class="form-check-label fs-4"
                                                            for="customSwitch3{{ $type->id }}">{{ $type->type }}</label>
                                                    </div>
                                                @else
                                                    <div class="form-check form-check-inline form-checkbox-info ">
                                                        <input type="checkbox" class="form-check-input"
                                                            value="{{ $type->id }}"
                                                            name="typeexpertise[{{ $company->id }}][{{ $type->id }}]"
                                                            id="customSwitch3{{ $type->id }}">
                                                        <label class="form-check-label fs-4"
                                                            for="customSwitch3{{ $type->id }}">{{ $type->type }}</label>
                                                    </div>
                                                @endif

                                            @empty
                                                <h5>Tableau Vide</h5>
                                            @endforelse
                                        </div>
                                    </div>


                                </div>
                            </div>
                        @empty
                            <h5>Tableau Vide</h5>
                        @endforelse
                    @endif
                </div>
                @if ($user->role_id == 6)
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <h4>Assigner un Type Document</h4>
                                <div class="row">
                                    @forelse ($typedocs as $type)
                                        @if ($user->hasTypeDocument($type->type))
                                            <div class="col-md-3">
                                                <div class="form-check form-check-inline form-switch form-checkbox-primary">
                                                    <input type="checkbox" checked class="form-check-input"
                                                        value="{{ $type->id }}" name="type[]"
                                                        id="customSwitch1{{ $type->id }}">
                                                    <label class="form-check-label fw-bold"
                                                        for="customSwitch1{{ $type->id }}">{{ $type->type }}</label>
                                                </div>
                                            </div>
                                        @else
                                            <div class="col-md-3">
                                                <div class="form-check form-check-inline form-switch">
                                                    <input type="checkbox" class="form-check-input"
                                                        value="{{ $type->id }}" name="type[]"
                                                        id="customSwitch1{{ $type->id }}">
                                                    <label style="color: rgb(37, 37, 37)" class="form-check-label fw-bold"
                                                        for="customSwitch1{{ $type->id }}">{{ $type->type }}</label>
                                                </div>
                                            </div>
                                        @endif
                                    @empty
                                        <div class="col-md 12">
                                            <h5>Tableau Vide</h5>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <h4>Assigner un Garage </h4>
                                <div class="row">
                                    @forelse ($garages as $garage)
                                        @if ($user->hasGarage($garage->id))
                                            <div class="col-md-3">
                                                <div
                                                    class="form-check form-check-inline form-switch form-checkbox-primary">
                                                    <input type="checkbox" checked class="form-check-input"
                                                        value="{{ $garage->id }}" name="garage[]"
                                                        id="customSwitch1{{ $garage->id }}">
                                                    <label class="form-check-label fw-bold"
                                                        for="customSwitch1{{ $garage->id }}">{{ $garage->libelle }}</label>
                                                </div>
                                            </div>
                                        @else
                                            <div class="col-md-3">
                                                <div class="form-check form-check-inline form-switch">
                                                    <input type="checkbox" class="form-check-input"
                                                        value="{{ $garage->id }}" name="garage[]"
                                                        id="customSwitch1{{ $garage->id }}">
                                                    <label style="color: rgb(37, 37, 37)" class="form-check-label fw-bold"
                                                        for="customSwitch1{{ $garage->id }}">{{ $garage->libelle }}</label>
                                                </div>
                                            </div>
                                        @endif
                                    @empty
                                        <div class="col-md 12">
                                            <h5>Tableau Vide</h5>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>

                    </div>
                @endif
                <div class="col-md-12">

                    <div class="mr-2 mt-3">
                        <div class="card">
                            <div class="card-body">
                                <h4>Assigner une permission</h4>
                                <div class="row">
                                    @forelse ($permissions as $permission)
                                        @if ($permission->key != 100)
                                            @if ($user->hasRolePermission($permission->permission))
                                                <div class="col-md-3">
                                                    <div
                                                        class="form-check form-check-inline form-switch form-checkbox-success">
                                                        <input type="checkbox" checked class="form-check-input"
                                                            value="{{ $permission->id }}" name="" disabled
                                                            id="customSwitch1{{ $permission->id }}">
                                                        <label class="form-check-label fw-bold"
                                                            for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                    </div>
                                                </div>
                                            @elseif ($user->hasPermission($permission->permission))
                                                <div class="col-md-3">
                                                    <div
                                                        class="form-check form-check-inline form-switch form-checkbox-primary">
                                                        <input type="checkbox" checked class="form-check-input"
                                                            value="{{ $permission->id }}" name="permission[]"
                                                            id="customSwitch1{{ $permission->id }}">
                                                        <label class="form-check-label fw-bold"
                                                            for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="col-md-3">
                                                    <div class="form-check form-check-inline form-switch">
                                                        <input type="checkbox" class="form-check-input"
                                                            value="{{ $permission->id }}" name="permission[]"
                                                            id="customSwitch1{{ $permission->id }}">
                                                        <label style="color: rgb(37, 37, 37)"
                                                            class="form-check-label fw-bold"
                                                            for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                    </div>
                                                </div>
                                            @endif
                                        @endif
                                    @empty
                                        <div class="col-md 12">
                                            <h5>Tableau Vide</h5>
                                        </div>
                                    @endforelse

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mr-2 mt-3">
                        <div class="card">
                            <div class="card-body">
                                <h4>Assigner Dashboard Permission</h4>
                                <div class="row">
                                    @forelse ($permissions as $permission)
                                        @if ($permission->key == 100)
                                            @if ($user->hasRolePermission($permission->permission))
                                                <div class="col-md-3">
                                                    <div
                                                        class="form-check form-check-inline form-switch form-checkbox-success">
                                                        <input type="checkbox" checked class="form-check-input"
                                                            value="{{ $permission->id }}" name="" disabled
                                                            id="customSwitch1{{ $permission->id }}">
                                                        <label class="form-check-label fw-bold"
                                                            for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                    </div>
                                                </div>
                                            @elseif ($user->hasPermission($permission->permission))
                                                <div class="col-md-3">
                                                    <div
                                                        class="form-check form-check-inline form-switch form-checkbox-primary">
                                                        <input type="checkbox" checked class="form-check-input"
                                                            value="{{ $permission->id }}" name="permission[]"
                                                            id="customSwitch1{{ $permission->id }}">
                                                        <label class="form-check-label fw-bold"
                                                            for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="col-md-3">
                                                    <div class="form-check form-check-inline form-switch">
                                                        <input type="checkbox" class="form-check-input"
                                                            value="{{ $permission->id }}" name="permission[]"
                                                            id="customSwitch1{{ $permission->id }}">
                                                        <label style="color: rgb(37, 37, 37)"
                                                            class="form-check-label fw-bold"
                                                            for="customSwitch1{{ $permission->id }}">{{ $permission->permission }}</label>
                                                    </div>
                                                </div>
                                            @endif
                                        @endif
                                    @empty
                                        <div class="col-md 12">
                                            <h5>Tableau Vide</h5>
                                        </div>
                                    @endforelse

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-3 ">
                    <button type="submit" class="btn btn-sm btn-primary"> Enregistrer</button>
                </div>
            </form>
        @else
            <form method="POST" action="{{ route('user.assign', [$user->id]) }}">
                <div class="row">
                    @csrf
                    <div class="mr-2 mt-3">
                        <div class="card">
                            <div class="card-body">
                                <h4>Assigner un Type Document</h4>
                                <div class="row">
                                    @forelse ($typedocs as $type)
                                        @if ($user->hasTypeDocument($type->type))
                                            <div class="col-md-3">
                                                <div
                                                    class="form-check form-check-inline form-switch form-checkbox-primary">
                                                    <input type="checkbox" checked class="form-check-input"
                                                        value="{{ $type->id }}" name="type[]"
                                                        id="customSwitch1{{ $type->id }}">
                                                    <label class="form-check-label fw-bold"
                                                        for="customSwitch1{{ $type->id }}">{{ $type->type }}</label>
                                                </div>
                                            </div>
                                        @else
                                            <div class="col-md-3">
                                                <div class="form-check form-check-inline form-switch">
                                                    <input type="checkbox" class="form-check-input"
                                                        value="{{ $type->id }}" name="type[]"
                                                        id="customSwitch1{{ $type->id }}">
                                                    <label style="color: rgb(37, 37, 37)" class="form-check-label fw-bold"
                                                        for="customSwitch1{{ $type->id }}">{{ $type->type }}</label>
                                                </div>
                                            </div>
                                        @endif
                                    @empty
                                        <div class="col-md 12">
                                            <h5>Tableau Vide</h5>
                                        </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="mt-3 ">
                        <button type="submit" class="btn btn-sm btn-primary"> Enregistrer</button>
                    </div>
                </div>
            </form>
        @endif
    </div>
@endsection
