<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contradictoires', function (Blueprint $table) {
            $table->id();
            $table->foreignId('dossier_id')->constrained()->onDelete(null);
            $table->foreignId('adverse_id')->onDelete(null);
            $table->foreignId('arbitre_id')->onDelete(null);
            $table->double('adverse_montant_accord')->nullable();
            $table->double('arbitre_montant_accord')->nullable();
            $table->date('date_reception_adverse')->nullable();
            $table->date('date_reception_arbitre')->nullable();
            $table->date('date_envoi_avis')->nullable();
            $table->date('date_envoi_demande_arbitrage')->nullable();
            $table->date('date_accord_adverse')->nullable();
            $table->date('date_accord_arbitre')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contradictoires');
    }
};
