<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('opponents', function (Blueprint $table) {
            $table->id();
            $table->string('civility')->nullable();
            $table->string('name')->nullable();
            $table->string('matricule')->nullable();
            $table->string('telephone')->nullable();
            $table->foreignId('company_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('vehicule_model_id')->nullable()->constrained()->onDelete(null);
            $table->string('numero_attestation')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('opponents');
    }
};
