<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('garages', function (Blueprint $table) {

            $table->id();
            $table->string('libelle');
            $table->string('email');
            $table->string('adress')->nullable();
            $table->double('lat')->nullable();
            $table->double('lng')->nullable();
            $table->foreignId('city_id')->constrained()->onDelete(null);
            $table->foreignId('user_id')->constrained()->onDelete(null);
            $table->string('url')->nullable();
            $table->boolean('verified')->default(false);
            $table->softDeletes();
            $table->timestamps();


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('garages');
    }
};
