<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Taux extends Model
{
    use HasFactory;
    protected $fillable = [
       'taux_1',
       'taux_2',
       'taux_3',
       'taux_mo_peinture',
       't1',
       't2',
       't3',
       'tp',
       'type_ingredient_id',
       'forfait_ing_pieces',
       'remise_facture',
       'remise_piece',
       'remise_sur_total_mo',
       'tva_deductible',
       'forfait_mo_1',
       'forfait_mo_2',
       'forfait_mo_3',
       'forfait_peinture',
       'taux_ing_opaque',
       'taux_ing_opaque_vernis',
       'taux_ing_metal',
       'taux_ing_metal_vernis',
       'taux_ing_nacre_vernis',
       'remise_facture1',
       'remise_sur_total_mo_peinture',
       'franchise',
       'franchise_fix',
       'taux_electricite',
       'te',
       'taux_mecanique',
       'tm',
       'taux_controle',
       'tc',
       'forfait_electricite',
       'forfait_mecanique',
       'forfait_controle',
       'taux_tva',
       'taux_ing',
       'vetuste'// 0=> client ,1=> Company
    ];

    public function devis()
    {
        return $this->hasOne(Devis::class);
    }

    public function rapport()
    {
        return $this->hasOne(Rapport::class);
    }

    public function typeingredient()
    {
        return $this->belongsTo(TypeIngredient::class,'type_ingredient_id');
    }


}
