<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Facture extends Model
{
    use HasFactory;
    protected $fillable= [
        'montant_facture',
        'dossier_id',
        'devis_status_id',
        'facture',
        'ref',
        'date_reception',
        'type_facture_id'
    ];

    public function typefacture()
    {
        return $this->belongsTo(TypeFacture::class,'type_facture_id');
    }

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }
    public function facturestatus()
    {
        return $this->belongsToMany(DevisStatus::class,'facture_status')->withPivot('user_id')->withTimestamps();
    }
    public function status()
    {
        return $this->belongsTo(DevisStatus::class,'devis_status_id');
    }
    public function montant()
    {
        return $this->hasOne(Montant::class);
    }

    public function document()
    {
        return $this->belongsToMany(Document::class,'document_facture')->withTimestamps();
    }

}
