<?php

namespace App\Http\Controllers;

use App\Models\Dossier;
use App\Models\Notification;
use App\Models\Ticket;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TicketController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $this->authorize('viewAny', Ticket::class);

        $dossier = Dossier::findOrFail($id);
        $tickets = Ticket::where('dossier_id', $id)->with('dossier', 'user', 'creator', 'status')->latest()->get();

        return view('configuration.ticket.index', compact('tickets', 'dossier'));
    }

    public function list()
    {
        $this->authorize('viewAny', Ticket::class);

        if (Auth::user()->role_id != 4) {
            $tickets = Ticket::where('user_id', Auth::user()->id)->Orwhere('creator_id', Auth::user()->id)->with('dossier', 'user', 'creator', 'status')->latest()->get();
        } else {
            $tickets = Ticket::with('dossier', 'user', 'creator', 'status')->latest()->get();
        }

        return view('configuration.ticket.list', compact('tickets'));
    }

    public function listterminer()
    {
        $this->authorize('create', Ticket::class);
        $tickets  = Ticket::where('creator_id', Auth::user()->id)->where('status_rendezvous_id', 3)->with('dossier', 'user', 'creator', 'status')->latest()->get();

        return view('configuration.ticket.listterminer', compact('tickets'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $this->authorize('create', Ticket::class);

        $dossier = Dossier::findOrFail($id);

        // if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
        //     return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        // }
        $userIds = DB::table('step_dossier')
            ->where('dossier_id', $dossier->id)
            ->pluck('user_id')
            ->toArray();
        $users = User::whereIn('id', $userIds)->where('id', '!=', Auth::user()->id)->get();

        return view('configuration.ticket.create', compact('dossier', 'users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', Ticket::class);

        $request->validate([
            'motif' => 'required',
            'user_id' => 'required'
        ]);

        $dossier = Dossier::findOrFail($request->dossier_id);
        $user = User::whereId($request->user_id)->firstOrFail();
        Ticket::create([
            'motif' => $request->motif,
            'user_id' => $request->user_id,
            'creator_id' => Auth::user()->id,
            'dossier_id' => $request->dossier_id,
            'status_rendezvous_id' => 2
        ]);
        $body = Auth::user()->name." a Créer une ticket pour ".$user->name." Dossier ".$dossier->ref;
        Notification::create([
            'user_id'=>Auth::user()->id,
            'dossier_id' => $request->dossier_id,
            'body'=>$body
        ]);
        \App\Services\SidebarCache::clear();
        return redirect()->route('Dossier.show', $dossier->id)->with('success', 'Ticket Créer avec Succés');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Ticket  $ticket
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->authorize('update', Ticket::class);

        $ticket = Ticket::whereId($id)->with('dossier', 'user', 'creator', 'status')->first();

        return view('configuration.ticket.show', compact('ticket'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Ticket  $ticket
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update', Ticket::class);

        $ticket = Ticket::whereId($id)->with('dossier', 'user', 'creator', 'status')->first();
        if ($ticket->user_id != Auth::user()->id) {
            return redirect()->route('Dossier.show', $ticket->dossier->id)->with('error', 'Ce ticket n est pas associé à votre compte');
        }
        return view('configuration.ticket.update', compact('ticket'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ticket  $ticket
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update', Ticket::class);

        $ticket = Ticket::whereId($id)->with('dossier', 'user', 'creator', 'status')->first();
        if ($ticket->user_id != Auth::user()->id) {
            return redirect()->route('Dossier.show', $ticket->dossier->id)->with('error', 'Ce ticket n est pas associé à votre compte');
        }

        if ($request->input('action') == "terminer") {

            $ticket->answer = $request->answer;
            $ticket->status_rendezvous_id = 3;
            $ticket->answer_at = now();
            $ticket->update();
            $body = Auth::user()->name." a Validée une ticket pour  Dossier ".$ticket->dossier->ref;
            Notification::create([
                'user_id'=>Auth::user()->id,
                'dossier_id' => $ticket->dossier_id,
                'body'=>$body
            ]);
        } else {

            $request->validate([
                'answer' => 'required'
            ]);
            $ticket->answer = $request->answer;
            $ticket->status_rendezvous_id = 1;
            $ticket->answer_at = now();
            $ticket->update();
            $body = Auth::user()->name." a Annulée une ticket pour Dossier ".$ticket->dossier->ref;
            Notification::create([
                'user_id'=>Auth::user()->id,
                'dossier_id' => $ticket->dossier_id,
                'body'=>$body
            ]);
        }
        \App\Services\SidebarCache::clear();
        return redirect()->route('Dossier.show', $ticket->dossier->id)->with('success', 'Ticket Créer avec Succés');
    }

    public function cloturer($id)
    {
        $ticket = Ticket::whereId($id)->with('dossier', 'user', 'creator', 'status')->first();
        if($ticket->creator_id != Auth::user()->id){
            return redirect()->back()->with('error','error');

        }
        $ticket->status_rendezvous_id = 4;
        $ticket->update();

        $body = Auth::user()->name." a Cloturée une ticket pour  Dossier ".$ticket->dossier->ref;
        Notification::create([
            'user_id'=>Auth::user()->id,
            'dossier_id' => $ticket->dossier_id,
            'body'=>$body
        ]);
        \App\Services\SidebarCache::clear();
        return redirect()->back()->with('success','Ticket Cloturée avec Succés');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ticket  $ticket
     * @return \Illuminate\Http\Response
     */
    public function destroy(Ticket $ticket)
    {
        //
    }
}
