<?php

namespace App\Http\Controllers;

use App\Models\Intermidiaire;
use Illuminate\Http\Request;

class IntermidiaireController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny',Intermidiaire::class);

        $intermidiaires = Intermidiaire::all();
        return view('configuration.intermidiaire.index',compact('intermidiaires'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create',Intermidiaire::class);

        return view('configuration.intermidiaire.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create',Intermidiaire::class);

        $request->validate([
            'company' => 'required|unique:intermidiaires,company',
            'phone'=>'required|unique:intermidiaires,phone',
            'email'=>'required|email|unique:intermidiaires,email'
         ]);
         //regex:/^(\+212|0)([ \-_/]*)(\d[ \-_/]*){9}/g

        Intermidiaire::create([
            'company'=>$request->company,
            'phone'=>$request->phone,
            'email'=>$request->email,
            'address'=>$request->address
        ]);

        return redirect()->route('Intermidiaire.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Intermidiaire  $intermidiaire
     * @return \Illuminate\Http\Response
     */
    public function show()
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Intermidiaire  $intermidiaire
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update',Intermidiaire::class);
        $intermidiaire = Intermidiaire::whereId($id)->first();
        return view('configuration.intermidiaire.edit',compact('intermidiaire'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Intermidiaire  $intermidiaire
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update',Intermidiaire::class);

        $intermidiaire = Intermidiaire::whereId($id)->first();

        $request->validate([
            'company'=>'required|unique:intermidiaires,company,'.$id . '',
            'phone'=>'required|unique:intermidiaires,phone,'.$id . '',
            'email'=>'required|email|unique:intermidiaires,email,'.$id . ''
        ]);

        $intermidiaire->company = $request->company;
        $intermidiaire->phone = $request->phone;
        $intermidiaire->email = $request->email;
        $intermidiaire->address=$request->address;

        $intermidiaire->update();

        return redirect()->route('Intermidiaire.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Intermidiaire  $intermidiaire
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // $this->authorize('delete',Intermidiaire::class);

        // $intermidiaire = Intermidiaire::whereId($id)->first();
        // $intermidiaire->delete();
        // return redirect()->route('Intermidiaire.index');

    }
}
