@extends('layouts.dashboard.app')

@section('style')
    <link rel="stylesheet" href="{{ asset('css/viewer.css') }}">

    <style>
        * {
            box-sizing: border-box;
        }

        #the-canvas {
            border: 1px solid black;
            direction: ltr;
        }

        * {
            box-sizing: border-box;
        }

        li {
            text-decoration: none;
        }

        /* Position the image container (needed to position the left and right arrows) */
        .container {
            position: relative;
        }

        /* Hide the images by default */
        .mySlides {
            display: none;
        }

        /* Add a pointer when hovering over the thumbnail images */
        .cursor {
            cursor: pointer;
        }

        /* Next & previous buttons */
        .prev,
        .next {
            cursor: pointer;
            position: absolute;
            top: 40%;
            width: auto;
            padding: 16px;
            margin-top: -50px;
            color: white;
            font-weight: bold;
            font-size: 20px;
            border-radius: 0 3px 3px 0;
            user-select: none;
            -webkit-user-select: none;
        }

        /* Position the "next button" to the right */
        .next {
            right: 0;
            border-radius: 3px 0 0 3px;
        }

        /* On hover, add a black background color with a little bit see-through */
        .prev:hover,
        .next:hover {
            background-color: rgba(0, 0, 0, 0.8);
        }

        /* Number text (1/3 etc) */
        .numbertext {
            color: #f2f2f2;
            font-size: 12px;
            padding: 8px 12px;
            position: absolute;
            top: 0;
        }

        /* Container for image text */
        .caption-container {
            text-align: center;
            background-color: #222;
            padding: 2px 16px;
            color: white;
        }

        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        /* Six columns side by side */
        .column {
            float: left;
            width: 16.66%;
        }

        /* Add a transparency effect for thumnbail images */
        .demo {
            opacity: 0.6;
        }

        .active,
        .demo:hover {
            opacity: 1;
        }

        .container {
            position: relative;
            width: 33%;
        }

        .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 28%;
            left: 82%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .container:hover .image {
            opacity: 0.8;
        }

        .container:hover .middle {
            opacity: 1;
        }

        .text {
            color: rgb(0, 0, 0);
            font-size: 16px;
        }
    </style>
@endsection
@section('content')


    <div class="row">
        <div class="col-6 mt-4">
            <input type="hidden" value="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                id="url">
            {{-- @if ($rapport->rapport_status_id == 4)
                <form action="{{ route('rapport.status') }}" class="mb-1" method="POST">
                    @csrf
                    <input type="hidden" value="{{ $rapport->id }}" name="rapport_id">
                    <ul class="nav nav-tabs nav-stacked ">


                        <div class="col-4">
                            <button type="submit" class="ml-5 btn btn-danger" style="" name="action" value="0">
                                Refuser </button>
                        </div>
                        <div class="col-4">
                            <button style="float: right" type="submit" class=" btn btn-success" name="action"
                                value="1"> Signer </button>
                        </div>
                    </ul>
                </form>
            @else --}}
            <div class="col-4 mb-2">
                <a class="btn btn-primary" target="_blank"
                    href="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}">Display</a>
                <a class="btn btn-success" style="float:right;"
                    href="{{ route('dossier.technique', $doc->dossier_id) }}">Modifier</a>

            </div>

            {{-- @endif --}}
            {{-- <div class="mt-1 mb-1 div">
                <button class="btn btn-sm btn-outline-info" id="prev">Previous</button>
                &nbsp; &nbsp;
                <span>Page: <span id="page_num"></span> / <span id="page_count"></span></span>
                &nbsp; &nbsp;

                <button class="btn btn-sm btn-outline-info" id="next">Next</button>
            </div> --}}
            {{-- <canvas id="the-canvas"></canvas> --}}
            <iframe width="500" height="800" src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}" frameborder="0"></iframe>

        </div>

    </div>
    <div class="row mt-2">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3" style="color: black">Observation</h4>
                    @if ($dossier)
                        <div class="accordion" id="">
                            @foreach ($dossier->observation as $key => $observation)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse-{{ $key }}" aria-expanded="false"
                                            aria-controls="">
                                            {{ $observation->user->name }}
                                        </button>
                                    </h2>
                                    <div id="collapse-{{ $key }}" class="accordion-collapse collapse "
                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <strong class="text-dark">{{ $observation->observation }}.</strong>
                                            <span>{{ $observation->created_at }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <form method="POST" action="{{ route('Observation.store') }}">
                        @csrf
                        <div class="col-md-12 mt-1 ml-3">
                            <input type="hidden" name="for_rapport" value="1">
                            <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                            <textarea name="observation" class="form-control mb-2" id="observation" cols="30" rows="10"></textarea>

                            <button class="mt-2 btn btn-info">Créer</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('script')

    <script src="https://mozilla.github.io/pdf.js/build/pdf.js"></script>

    <script>
        // If absolute URL from the remote server is provided, configure the CORS
        // header on that server.

        var url = document.getElementById('url').value;
        // Loaded via <script> tag, create shortcut to access PDF.js exports.
        var pdfjsLib = window['pdfjs-dist/build/pdf'];
        console.log(url);
        // The workerSrc property shall be specified.
        pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://mozilla.github.io/pdf.js/build/pdf.worker.js';

        var pdfDoc = null,
            pageNum = 1,
            pageRendering = false,
            pageNumPending = null,
            scale = 0.8,
            canvas = document.getElementById('the-canvas'),
            ctx = canvas.getContext('2d');

        /**
         * Get page info from document, resize canvas accordingly, and render page.
         * @param num Page number.
         */
        function renderPage(num) {
            pageRendering = true;
            // Using promise to fetch the page
            pdfDoc.getPage(num).then(function(page) {
                var viewport = page.getViewport({
                    scale: scale
                });
                canvas.height = viewport.height;
                canvas.width = viewport.width;

                // Render PDF page into canvas context
                var renderContext = {
                    canvasContext: ctx,
                    viewport: viewport
                };
                var renderTask = page.render(renderContext);

                // Wait for rendering to finish
                renderTask.promise.then(function() {
                    pageRendering = false;
                    if (pageNumPending !== null) {
                        // New page rendering is pending
                        renderPage(pageNumPending);
                        pageNumPending = null;
                    }
                });
            });

            // Update page counters
            document.getElementById('page_num').textContent = num;
        }

        /**
         * If another page rendering in progress, waits until the rendering is
         * finised. Otherwise, executes rendering immediately.
         */
        function queueRenderPage(num) {
            if (pageRendering) {
                pageNumPending = num;
            } else {
                renderPage(num);
            }
        }

        /**
         * Displays previous page.
         */
        function onPrevPage() {
            if (pageNum <= 1) {
                return;
            }
            pageNum--;
            queueRenderPage(pageNum);
        }
        document.getElementById('prev').addEventListener('click', onPrevPage);

        /**
         * Displays next page.
         */
        function onNextPage() {
            if (pageNum >= pdfDoc.numPages) {
                return;
            }
            pageNum++;
            queueRenderPage(pageNum);
        }
        document.getElementById('next').addEventListener('click', onNextPage);

        /**
         * Asynchronously downloads PDF.
         */
        pdfjsLib.getDocument(url).promise.then(function(pdfDoc_) {
            pdfDoc = pdfDoc_;
            document.getElementById('page_count').textContent = pdfDoc.numPages;

            // Initial/first page rendering
            renderPage(pageNum);
        });

        var $mediaElements = $('.media');
        var canvas = document.getElementById("the-canvas");

        var ctx = canvas.getContext('2d');

        ctx.fillStyle = "rgb(0,255,255)";
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        ctx.beginPath();
        ctx.fillStyle = "rgb(200,0,0)";
        ctx.arc(canvas.width / 2, canvas.height / 2, 50, 0, Math.PI * 2);
        ctx.fill();
    </script>
@endsection
