@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">

        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h2>Gestion de Tickets</h2>

                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Dossier</th>
                                        <th>Reclameur</th>
                                        <th>Utilisateur</th>
                                        <th>Status</th>
                                        <th>Date Reponse</th>
                                        <th>Date Creation</th>
                                        <th>Modifier</th>
                                        <th>Detail</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($tickets as $ticket)
                                        <tr>
                                            <td><a
                                                    href="{{ route('Dossier.show', $ticket->dossier_id) }}">{{ $ticket->dossier->ref }}</a>
                                            </td>
                                            <td>{{ $ticket->creator->name }}</td>
                                            <td>{{ $ticket->user->name }}</td>
                                            <td>
                                                <span
                                                    class="badge @switch($ticket->status->id) @case(1)           bg-danger           @break       @case(2)           bg-primary            @break        @default            bg-success @endswitch">{{ $ticket->status->status }}</span>
                                            </td>
                                            <td>{{ $ticket->answer_at }}</td>
                                            <td>{{ $ticket->created_at }}</td>

                                            <td>
                                                @if ($ticket->user_id == Auth::user()->id)
                                                    @if ($ticket->status_rendezvous_id == 2)
                                                        <a class="btn btn-sm btn-info rounded-pill"
                                                            href="{{ route('Ticket.edit', [$ticket->id]) }}"><i
                                                                class="uil uil-pen fs-5"></i></a>
                                                    @endif
                                                @endif
                                            </td>
                                            <td>
                                                    <a class="btn btn-sm btn-success rounded-pill"
                                                        href="{{ route('Ticket.show', [$ticket->id]) }}"><i
                                                            class="uil uil-eye fs-5"></i></a>

                                            </td>


                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
