@extends('layouts.dashboard.app')

@section('content')
    <div class="row mt-2">
        <div class="col-12">
            <div class="card mb-2">
                <div class="card-body">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="page-title" style="font-size: 25px">Meeting </h4>
                        </div>
                    </div>
                    @can('annuler', App\Models\Meeting::class)
                        @if ($meeting->meeting_status_id == 2)
                            <form action="{{ route('Meeting.status', $meeting->id) }}" class="" method="post">
                                <div class="col-12">
                                    <div class="card mb-2">
                                        <div class="card-body">
                                            <div class="col-12">
                                                <div class="btn-group" role="group" aria-label="Basic example">
                                                    @csrf
                                                    @method('PUT')
                                                    <button style="" name="action" value="{{ $status->id }}"
                                                        class="btn btn-{{ $status->color }} ml-3">
                                                        {{ $status->status }}
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        @endif
                    @endcan
                    <div class="row g-2">
                        <div class="card">
                            <div class="card-body">
                                <table id="" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>User</th>
                                            <th>Ref Dossier</th>
                                            <th>Garage</th>
                                            <th>Date</th>
                                            <th>Start</th>
                                            <th>Adress</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="table-user">{{ $meeting->user->name ?? null }}</td>
                                            <td>{{ $meeting->dossier->ref ?? null }}</td>
                                            <td>{{ $meeting->garage->libelle ?? null }}</td>
                                            <td>{{ $meeting->date ?? null }}</td>
                                            <td>{{ $meeting->start ?? null }}</td>
                                            <td>{{ $meeting->adress ?? null }}</td>
                                            <td><span
                                                    class="badge bg-{{ $meeting->meetingstatus->color }}">{{ $meeting->meetingstatus->status }}</span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @if ($meeting->meeting_status_id == 2)
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label for="date" class="form-label">Observation :</label>
                                <textarea class="form-control mb-2  @error('observation') is-invalid @enderror" name="observation" id=""
                                    cols="30" rows="5"></textarea>
                                @error('observation')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                            </div>
                    @endif
                    <div class="col-8">
                        @if ($observations)
                            <div class="accordion" id="">
                                @foreach ($observations as $key => $observation)
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#collapse-{{ $key }}"
                                                aria-expanded="false" aria-controls="">
                                                {{ $observation->user->name }}
                                            </button>
                                        </h2>
                                        <div id="collapse-{{ $key }}" class="accordion-collapse collapse "
                                            aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                            <div class="accordion-body">
                                                <strong class="text-dark">{{ $observation->observation }}.</strong>
                                                <span>{{ $observation->created_at }}</span>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>

                {{-- <div class="row g-2 mb-3">
                    <div class="col-md-12">
                        <h4 class="header-title mb-2 mt-3">Localisation :</h4>
                        <div id="map" class="gmaps" style="height: 60vh">
                        </div>
                    </div>

                </div> --}}

                </form>
            </div>
        </div>
    </div>
    </div>
    </div>
@endsection
@section('script')
    <script src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAP_KEY') }}&libraries=places&callback=initMap"
        async defer></script>
    <script>
        let map;

        function initMap() {
            map = new google.maps.Map(document.getElementById("map"), {
                center: {
                    lat: 30.168831728404875,
                    lng: -7.46378273987113,
                    zoom: 6
                },
                zoom: 6,
                scrollwheel: true,
            });

            setMarkers(map);
            setMarkers2(map);



        }

        const locations = <?php print json_encode($markers); ?>;
        const image1 = "https://cdn-icons-png.flaticon.com/512/75/75751.png";

        function setMarkers(map) {
            const location = locations;

            new google.maps.Marker({
                position: {
                    lat: parseFloat(location.lat),
                    lng: parseFloat(location.lng)
                },
                label: {
                    color: 'blue',
                    fontWeight: 'bold',
                    text: location.libelle,
                },
                icon: {
                    url: image1,
                    size: new google.maps.Size(36, 50),
                    scaledSize: new google.maps.Size(36, 50),
                    anchor: new google.maps.Point(0, 50),
                    labelOrigin: new google.maps.Point(9, 8)

                },
                map,
                title: location.libelle,
                zIndex: location.lng,
            });

            // console.log(locations[i]);
        }

        const Alocation = <?php print json_encode($agents); ?>;
        const image =
            "https://upload.wikimedia.org/wikipedia/commons/thumb/5/59/User-avatar.svg/1200px-User-avatar.svg.png";

        function setMarkers2(map) {

            const location = Alocation;

            new google.maps.Marker({
                position: {
                    lat: parseFloat(location.lat),
                    lng: parseFloat(location.lng)
                },
                label: {
                    color: 'black',
                    fontWeight: 'bold',
                    text: location.agent,

                },
                icon: {
                    url: image,
                    size: new google.maps.Size(36, 50),
                    scaledSize: new google.maps.Size(36, 50),
                    anchor: new google.maps.Point(0, 50),
                    labelOrigin: new google.maps.Point(9, 8)

                },
                map,
                zIndex: location.lng,
            });

            // console.log(locations[i]);
        }
    </script>
@endsection
