@extends('layouts.dashboard.app')

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-info mb-3">Dossier {{ $dossier->ref }} @if ($dossier->sinistre_douteux)
                                <span class="badge bg-success">Sinistre Douteux</span>
                            @endif
                        </h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Reference</th>
                                        <th>Matricule</th>
                                        <th>Compagnie</th>
                                        <th>Garantie</th>
                                        <th>Date Sinistre</th>
                                        <th>Date Reception</th>
                                        <th>Type de Dossier</th>
                                        <th>Mode</th>
                                        <th>Vehicule</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <input type="hidden" value="{{ $dossier->id }}" id="id">
                                        <td class="text-dark">{{ $dossier->ref ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->matricule ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->company->company ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->guarantee->guarantee ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->date_sinistre ?? null }}</td>
                                        <td class="text-dark">{{ $dossier->date_reception ?? null }}</td>
                                        <td> <span
                                                class="badge badge-primary-lighten">{{ $dossier->typeexpertise->type ?? null }}</span>
                                        </td>
                                        <td> <span
                                                class="badge badge-success-lighten">{{ $dossier->mode->mode ?? null }}</span>
                                        </td>
                                        <td>{{ $dossier->vehiculemodel->name ?? null }}/{{ $dossier->vehiculemodel->brand->brand ?? null }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->


        </div>
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <label for=""> Appel Video Lien :</label>
                        <input class="form-control" readonly id="myInput" value="{{ $url }}" type="text">
                        <button onclick="myFunction()" class="btn btn-dark mt-2">Copier</button>
                        <a href="https://web.whatsapp.com/" target="_blank" class="btn btn-success mt-2">Whatsapp</a>
                        <a href="{{ $url }}" class="btn btn-info mt-2" style="float: right" target="_blank" >Ouvrir</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        function myFunction() {
            // Get the text field
            var copyText = document.getElementById("myInput");
            // Select the text field
            copyText.select();
            copyText.setSelectionRange(0, 99999); // For mobile devices
            // Copy the text inside the text field
            navigator.clipboard.writeText(copyText.value);
            // Alert the copied text
            alert("Copied");
        }
    </script>
@endsection
