<?php

namespace App\Policies;

use App\Models\Dossier;
use App\Models\Meeting;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Auth;

class MeetingPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if($user->hasPermission('naviguer_meetings') || $user->hasRolePermission('naviguer_meetings') || $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        if($user->role_id === 4 )
        {
            return true;
        }

        if($user->hasPermission('afficher_meetings') || $user->hasRolePermission('afficher_meetings'))
        {
            // $meet = Meeting::whereId($meeting->id)->with('dossier');
            // $count = Dossier::whereId($meeting->dossier_id)->whereHas('step', function ($query) use ($user) {
            //     $query->where('user_id', $user->id);
            // })->with('step')->count();
            // if ($count > 0) {
            //     return true;
            // }
            return true;
        }

    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if($user->hasPermission('ajouter_meetings') || $user->hasRolePermission('ajouter_meetings') || $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if($user->hasPermission('modifier_meetings') || $user->hasRolePermission('modifier_meetings') || $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if( $user->role_id === 4 ){
            return true;
        }
    }

    public function annuler(User $user){

        if($user->hasPermission('annuler_meetings') || $user->hasRolePermission('annuler_meetings') || $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user)
    {

    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Meeting  $meeting
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user)
    {
        //
    }
}
