<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class ResetFiles extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:reset';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RESET Files';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
         $files = File::files(public_path('attachments'));
        if($files){
            foreach ($files as $file) {
                File::delete($file);
            }
        }
        return Command::SUCCESS;
    }
}
