@extends('layouts.dashboard.app')

@section('style')
    <style>
        .email-list {
            transform: rotate(180deg);
        }

        .email-list>li {
            transform: rotate(-180deg);
        }
    </style>
@endsection
@section('content')
    <div class="row">
        <!-- Right Sidebar -->
        <div class="col-12">
            <div class="card">

                <div class="card-body">

                    <div class="col-12 ">
                        <form id="myForm" action="{{ route('Email.inbox') }}" method="get">
                            <label for="company_id">Mon EMAIL </label>
                            <select id="mySelect" name="company_id" id="company_id"
                                class="form-control @error('company_id') is-invalid @enderror">
                                <option value="{{ $company->id }}">{{ $company->company ?? null }}</option>
                                @foreach ($user->company as $item)
                                    @if ($item->id != $company->id)
                                        <option value="{{ $item->id }}">
                                            {{ $item->company }}</option>
                                    @endif
                                @endforeach


                            </select>
                            <div class="input-group mt-2">
                                <input type="search" name="search" class="form-control dropdown-toggle"
                                    placeholder="Search..." id="top-search">
                                <button class="input-group-text btn btn-primary" type="submit">Search</button>
                            </div>
                        </form>
                    </div>


                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card">

                <div class="card-body">
                    <!-- Left sidebar -->
                    <div class="row mb-3">
                        <div class="d-flex ">
                            <div class="col-md-6">
                                <a class="btn btn-sm btn-warning" href="{{ route('Email.inbox') }}"><i
                                        style="font-size: 20px" class="uil uil-refresh"></i></a>
                            </div>
                            <div class="col-md-6">
                                <button type="button" style="float: right" class="btn btn-info mt-4 mb-2"
                                    data-bs-toggle="modal" data-bs-target="#signup-modal">
                                    Nouveau
                                </button>
                                @include('email.modal')
                            </div>

                        </div>
                    </div>

                    <!-- End Left sidebar -->
                    <div class="mt-3" id="tbl">
                        <ul class="email-list">
                            {{-- foreach ($messages as $message) {
                            echo $message->getSubject() . '<br />';
                            echo 'Attachments: ' . $message->getAttachments()->count() . '<br />';
                            echo $message->getHTMLBody(); --}}
                            @foreach ($messages as $message)
                                <li id="tr">
                                    <div class="email-sender-info">
                                        <div class="checkbox-wrapper-mail">
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" id="mail7">
                                                <label class="form-check-label" for="mail7"></label>
                                            </div>
                                        </div>
                                        <span class="star-toggle mdi mdi-star-outline"></span>
                                        <a href="{{ route('Email.showinbox', ['id' => $message->getUid(), 'company' => $company->id])}}" class="email-title">
                                            {{ $message->from[0]->mail }}
                                        </a>
                                    </div>
                                    <div class="email-content" style="left: 360px">
                                        <a href="{{ route('Email.showinbox', ['id' => $message->getUid(), 'company' => $company->id]) }}"
                                            class="email-subject">
                                            <span>
                                                {{ $message->getSubject() }}
                                            </span>
                                        </a>
                                        <div class="email-date">
                                            {{ Carbon\Carbon::parse($message->date)->format('d/m') }}
                                        </div>
                                    </div>
                                    <div class="email-action-icons">
                                        <ul class="list-inline">
                                            <li class="list-inline-item">
                                                <a href="javascript: void(0);"><i
                                                        class="mdi mdi-archive email-action-icons-item"></i></a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a href="javascript: void(0);"><i
                                                        class="mdi mdi-delete email-action-icons-item"></i></a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a href="javascript: void(0);"><i
                                                        class="mdi mdi-email-mark-as-unread email-action-icons-item"></i></a>
                                            </li>
                                            <li class="list-inline-item">
                                                <a href="javascript: void(0);"><i
                                                        class="mdi mdi-clock email-action-icons-item"></i></a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    <!-- end .mt-4 -->

                    {{-- <div class="row">
                        <!-- end col-->
                        <div class="col-5">
                            <div class="btn-group float-end">
                                <div class="d-flex justify-content-center">
                                    {!! $messages->links() !!}
                                </div>
                            </div>
                        </div> <!-- end col-->
                    </div> --}}
                    <!-- end row-->
                </div>
                <!-- end inbox-rightbar-->
            </div>
        </div> <!-- end card-box -->

    </div> <!-- end Col -->
    <!-- End row -->

    <!-- Compose Modal -->
    <div id="compose-modal" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog"
        aria-labelledby="compose-header-modalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="compose-header-modalLabel">Nouveau Mail</h4>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <form action="{{ route('Email.send') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="p-1">
                        <div class="modal-body px-3 pt-3 pb-0">
                            <form>
                                <div class="mb-2">
                                    <label for="msgto" class="form-label">To</label>
                                    <input type="text" id="msgto" name="to" class="form-control"
                                        placeholder="Example@email.com">
                                </div>
                                <div class="mb-2">
                                    <label for="mailsubject" class="form-label">Subject</label>
                                    <input type="text" name="subject" id="mailsubject" class="form-control"
                                        placeholder="Your subject">
                                </div>
                                <div class="write-mdg-box mb-3">
                                    <label class="form-label">Message</label>
                                    <textarea name="body" id="editor"></textarea>
                                </div>
                            </form>
                        </div>
                        <div class="px-3 pb-3">
                            <button type="submit" class="btn btn-primary" data-bs-dismiss="modal"><i
                                    class="mdi mdi-send me-1"></i> Send Message</button>
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->


    <!-- Footer Start -->


    </div>
@endsection
@section('script')
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script>
        function refresh() {
            window.location.reload("Refresh")
        }
        var form = document.getElementById('myForm');
        var select = document.getElementById('mySelect');
        select.addEventListener('change', function() {
            // Submit the form
            form.submit();
        });
    </script>
    {{-- <script>
        $(function() {
            $("ul").each(function(elem, index) {
                var arr = $.makeArray($("#tr", this).detach());
                arr.reverse();
                $(this).append(arr);
            });
        });
    </script> --}}
@endsection
