@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des Intermidiaire</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Compagnie</th>
                                        <th>Email</th>
                                        <th>Telephone</th>
                                        <th>Adresse</th>

                                        @can('update', App\Models\Intermidiaire::class)
                                        <th>Modifier</th>
                                        @endcan
                                        {{-- @can('delete', App\Models\Intermidiaire::class)
                                        <th>Supprimer</th>
                                        @endcan --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($intermidiaires as $intermidiaire)
                                        <tr>
                                            <td>{{ $intermidiaire->id }}</td>
                                            <td>{{ $intermidiaire->company }}</td>
                                            <td>{{ $intermidiaire->email }}</td>
                                            <td>{{ $intermidiaire->phone }}</td>
                                            <td>{{ $intermidiaire->address ?? null }}</td>

                                            @can('update', App\Models\Intermidiaire::class)
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Intermidiaire.edit', $intermidiaire->id) }}">
                                                    <i class="uil uil-pen fs-5"></i>
                                                </a>
                                            </td>
                                            @endcan
                                            {{-- @can('delete', App\Models\Intermidiaire::class)
                                            <td>
                                                <form action="{{ route('Intermidiaire.destroy', $intermidiaire->id) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit"><i
                                                            class="uil uil-trash fs-5"></i></button>
                                                </form>
                                            </td>
                                            @endcan --}}
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
