@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <!--<button class="btn btn-outline-success mb-2" onclick="exportToExcel()">Exporter Excel</button>-->
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Type Piéce</th>
                                        <th>Piéce</th>
                                        <th>Modifier</th> 
                                        <th>Supprimer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($pieces as $piece)
                                        <tr>
                                            <td>{{ $piece->id }}</td>
                                            <td>{{ $piece->piecetype->type }}</td>
                                            <td>{{ $piece->piece }}</td>
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="{{ route('Piece.edit', [$piece->id]) }}">
                                                       <i class="uil uil-pen fs-5"></i>
                                                </a>
                                            </td>
                                            <td>
                                                <form action="{{ route('Piece.destroy', [$piece->id]) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                            <i class="uil uil-trash fs-5"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
