<?php

namespace App\Policies;

use App\Models\Intermidiare;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Auth;

class IntermidiairePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('naviguer_intermidiaires') || $user->hasRolePermission('naviguer_intermidiaires') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Intermidiare  $intermidiare
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('afficher_intermidiaires') || $user->hasRolePermission('afficher_intermidiaires') ){
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('ajouter_intermidiaires') || $user->hasRolePermission('ajouter_intermidiaires') )
        {
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Intermidiare  $intermidiare
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('modifier_intermidiaires') || $user->hasRolePermission('modifier_intermidiaires') ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Intermidiare  $intermidiare
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if( $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Intermidiare  $intermidiare
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Intermidiare  $intermidiare
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user)
    {
        //
    }
}
